// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Resiliency score of each scoring component. For more information about scoring component, see [Calculating resiliency score](https://docs.aws.amazon.com/resilience-hub/latest/userguide/calculate-score.html).
 */
public class ScoringComponentResiliencyScore private constructor(builder: Builder) {
    /**
     * Number of recommendations that were excluded from the assessment.
     *
     * For example, if the `excludedCount` for Alarms coverage scoring component is 7, it indicates that 7 Amazon CloudWatch alarms are excluded from the assessment.
     */
    public val excludedCount: kotlin.Long = builder.excludedCount
    /**
     * Number of recommendations that must be implemented to obtain the maximum possible score for the scoring component. For SOPs, alarms, and tests, these are the number of recommendations that must be implemented. For compliance, these are the number of Application Components that have breached the resiliency policy.
     *
     * For example, if the `outstandingCount` for Alarms coverage scoring component is 5, it indicates that 5 Amazon CloudWatch alarms need to be implemented to achieve the maximum possible score.
     */
    public val outstandingCount: kotlin.Long = builder.outstandingCount
    /**
     * Maximum possible score that can be obtained for the scoring component.
     *
     * For example, if the `possibleScore` is 20 points, it indicates the maximum possible score you can achieve for the scoring component when you run a new assessment after implementing all the Resilience Hub recommendations.
     */
    public val possibleScore: kotlin.Double = builder.possibleScore
    /**
     * Resiliency score points given for the scoring component. The score is always less than or equal to the `possibleScore`.
     */
    public val score: kotlin.Double = builder.score

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.ScoringComponentResiliencyScore = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScoringComponentResiliencyScore(")
        append("excludedCount=$excludedCount,")
        append("outstandingCount=$outstandingCount,")
        append("possibleScore=$possibleScore,")
        append("score=$score")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = excludedCount.hashCode()
        result = 31 * result + (outstandingCount.hashCode())
        result = 31 * result + (possibleScore.hashCode())
        result = 31 * result + (score.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScoringComponentResiliencyScore

        if (excludedCount != other.excludedCount) return false
        if (outstandingCount != other.outstandingCount) return false
        if (!(possibleScore?.equals(other.possibleScore) ?: (other.possibleScore == null))) return false
        if (!(score?.equals(other.score) ?: (other.score == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.ScoringComponentResiliencyScore = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Number of recommendations that were excluded from the assessment.
         *
         * For example, if the `excludedCount` for Alarms coverage scoring component is 7, it indicates that 7 Amazon CloudWatch alarms are excluded from the assessment.
         */
        public var excludedCount: kotlin.Long = 0L
        /**
         * Number of recommendations that must be implemented to obtain the maximum possible score for the scoring component. For SOPs, alarms, and tests, these are the number of recommendations that must be implemented. For compliance, these are the number of Application Components that have breached the resiliency policy.
         *
         * For example, if the `outstandingCount` for Alarms coverage scoring component is 5, it indicates that 5 Amazon CloudWatch alarms need to be implemented to achieve the maximum possible score.
         */
        public var outstandingCount: kotlin.Long = 0L
        /**
         * Maximum possible score that can be obtained for the scoring component.
         *
         * For example, if the `possibleScore` is 20 points, it indicates the maximum possible score you can achieve for the scoring component when you run a new assessment after implementing all the Resilience Hub recommendations.
         */
        public var possibleScore: kotlin.Double = 0.0
        /**
         * Resiliency score points given for the scoring component. The score is always less than or equal to the `possibleScore`.
         */
        public var score: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.ScoringComponentResiliencyScore) : this() {
            this.excludedCount = x.excludedCount
            this.outstandingCount = x.outstandingCount
            this.possibleScore = x.possibleScore
            this.score = x.score
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.ScoringComponentResiliencyScore = ScoringComponentResiliencyScore(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
