// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a recommendation.
 */
public class RecommendationItem private constructor(builder: Builder) {
    /**
     * Specifies if the recommendation has already been implemented.
     */
    public val alreadyImplemented: kotlin.Boolean? = builder.alreadyImplemented
    /**
     * Indicates the previously implemented Amazon CloudWatch alarm discovered by Resilience Hub.
     */
    public val discoveredAlarm: aws.sdk.kotlin.services.resiliencehub.model.Alarm? = builder.discoveredAlarm
    /**
     * Indicates the reason for excluding an operational recommendation.
     */
    public val excludeReason: aws.sdk.kotlin.services.resiliencehub.model.ExcludeRecommendationReason? = builder.excludeReason
    /**
     * Indicates if an operational recommendation item is excluded.
     */
    public val excluded: kotlin.Boolean? = builder.excluded
    /**
     * Indicates the experiment created in FIS that was discovered by Resilience Hub, which matches the recommendation.
     */
    public val latestDiscoveredExperiment: aws.sdk.kotlin.services.resiliencehub.model.Experiment? = builder.latestDiscoveredExperiment
    /**
     * Identifier of the resource.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * Identifier of the target account.
     */
    public val targetAccountId: kotlin.String? = builder.targetAccountId
    /**
     * The target region.
     */
    public val targetRegion: kotlin.String? = builder.targetRegion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.RecommendationItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationItem(")
        append("alreadyImplemented=$alreadyImplemented,")
        append("discoveredAlarm=$discoveredAlarm,")
        append("excludeReason=$excludeReason,")
        append("excluded=$excluded,")
        append("latestDiscoveredExperiment=$latestDiscoveredExperiment,")
        append("resourceId=$resourceId,")
        append("targetAccountId=$targetAccountId,")
        append("targetRegion=$targetRegion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alreadyImplemented?.hashCode() ?: 0
        result = 31 * result + (discoveredAlarm?.hashCode() ?: 0)
        result = 31 * result + (excludeReason?.hashCode() ?: 0)
        result = 31 * result + (excluded?.hashCode() ?: 0)
        result = 31 * result + (latestDiscoveredExperiment?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (targetAccountId?.hashCode() ?: 0)
        result = 31 * result + (targetRegion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationItem

        if (alreadyImplemented != other.alreadyImplemented) return false
        if (discoveredAlarm != other.discoveredAlarm) return false
        if (excludeReason != other.excludeReason) return false
        if (excluded != other.excluded) return false
        if (latestDiscoveredExperiment != other.latestDiscoveredExperiment) return false
        if (resourceId != other.resourceId) return false
        if (targetAccountId != other.targetAccountId) return false
        if (targetRegion != other.targetRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.RecommendationItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies if the recommendation has already been implemented.
         */
        public var alreadyImplemented: kotlin.Boolean? = null
        /**
         * Indicates the previously implemented Amazon CloudWatch alarm discovered by Resilience Hub.
         */
        public var discoveredAlarm: aws.sdk.kotlin.services.resiliencehub.model.Alarm? = null
        /**
         * Indicates the reason for excluding an operational recommendation.
         */
        public var excludeReason: aws.sdk.kotlin.services.resiliencehub.model.ExcludeRecommendationReason? = null
        /**
         * Indicates if an operational recommendation item is excluded.
         */
        public var excluded: kotlin.Boolean? = null
        /**
         * Indicates the experiment created in FIS that was discovered by Resilience Hub, which matches the recommendation.
         */
        public var latestDiscoveredExperiment: aws.sdk.kotlin.services.resiliencehub.model.Experiment? = null
        /**
         * Identifier of the resource.
         */
        public var resourceId: kotlin.String? = null
        /**
         * Identifier of the target account.
         */
        public var targetAccountId: kotlin.String? = null
        /**
         * The target region.
         */
        public var targetRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.RecommendationItem) : this() {
            this.alreadyImplemented = x.alreadyImplemented
            this.discoveredAlarm = x.discoveredAlarm
            this.excludeReason = x.excludeReason
            this.excluded = x.excluded
            this.latestDiscoveredExperiment = x.latestDiscoveredExperiment
            this.resourceId = x.resourceId
            this.targetAccountId = x.targetAccountId
            this.targetRegion = x.targetRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.RecommendationItem = RecommendationItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.Alarm] inside the given [block]
         */
        public fun discoveredAlarm(block: aws.sdk.kotlin.services.resiliencehub.model.Alarm.Builder.() -> kotlin.Unit) {
            this.discoveredAlarm = aws.sdk.kotlin.services.resiliencehub.model.Alarm.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.Experiment] inside the given [block]
         */
        public fun latestDiscoveredExperiment(block: aws.sdk.kotlin.services.resiliencehub.model.Experiment.Builder.() -> kotlin.Unit) {
            this.latestDiscoveredExperiment = aws.sdk.kotlin.services.resiliencehub.model.Experiment.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
