// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutDraftAppVersionTemplateRequest private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * A JSON string that provides information about your application structure. To learn more about the `appTemplateBody` template, see the sample template provided in the *Examples* section.
     *
     * The `appTemplateBody` JSON string has the following structure:
     * + **`resources`**The list of logical resources that must be included in the Resilience Hub application.Type: ArrayDon't add the resources that you want to exclude.Each `resources` array item includes the following fields:
     *    + *`logicalResourceId`*Logical identifier of the resource.Type: ObjectEach `logicalResourceId` object includes the following fields:
     *       + `identifier`Identifier of the resource.Type: String
     *       + `logicalStackName`The name of the CloudFormation stack this resource belongs to.Type: String
     *       + `resourceGroupName`The name of the resource group this resource belongs to.Type: String
     *       + `terraformSourceName`The name of the Terraform S3 state file this resource belongs to.Type: String
     *       + `eksSourceName`Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.This parameter accepts values in "eks-cluster/namespace" format.Type: String
     *    + *`type`*The type of resource.Type: string
     *    + *`name`*The name of the resource.Type: String
     *    + `additionalInfo`Additional configuration parameters for an Resilience Hub application. If you want to implement `additionalInfo` through the Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.Key: `"failover-regions"`Value: `"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"`
     * + **`appComponents`**List of Application Components that this resource belongs to. If an Application Component is not part of the Resilience Hub application, it will be added.Type: ArrayEach `appComponents` array item includes the following fields:
     *    + `name`Name of the Application Component.Type: String
     *    + `type`Type of Application Component. For more information about the types of Application Component, see [Grouping resources in an AppComponent](https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html).Type: String
     *    + `resourceNames`The list of included resources that are assigned to the Application Component.Type: Array of strings
     *    + `additionalInfo`Additional configuration parameters for an Resilience Hub application. If you want to implement `additionalInfo` through the Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.Key: `"failover-regions"`Value: `"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"`
     * + **`excludedResources`**The list of logical resource identifiers to be excluded from the application.Type: ArrayDon't add the resources that you want to include.Each `excludedResources` array item includes the following fields:
     *    + *`logicalResourceIds`*Logical identifier of the resource.Type: ObjectYou can configure only one of the following fields:
     *       + `logicalStackName`
     *       + `resourceGroupName`
     *       + `terraformSourceName`
     *       + `eksSourceName`
     * Each `logicalResourceIds` object includes the following fields:
     *       + `identifier`Identifier of the resource.Type: String
     *       + `logicalStackName`The name of the CloudFormation stack this resource belongs to.Type: String
     *       + `resourceGroupName`The name of the resource group this resource belongs to.Type: String
     *       + `terraformSourceName`The name of the Terraform S3 state file this resource belongs to.Type: String
     *       + `eksSourceName`Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.This parameter accepts values in "eks-cluster/namespace" format.Type: String
     * + **`version`**Resilience Hub application version.
     * + `additionalInfo`Additional configuration parameters for an Resilience Hub application. If you want to implement `additionalInfo` through the Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.Key: `"failover-regions"`Value: `"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"`
     */
    public val appTemplateBody: kotlin.String = requireNotNull(builder.appTemplateBody) { "A non-null value must be provided for appTemplateBody" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.PutDraftAppVersionTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutDraftAppVersionTemplateRequest(")
        append("appArn=$appArn,")
        append("appTemplateBody=$appTemplateBody")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (appTemplateBody.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutDraftAppVersionTemplateRequest

        if (appArn != other.appArn) return false
        if (appTemplateBody != other.appTemplateBody) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.PutDraftAppVersionTemplateRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * A JSON string that provides information about your application structure. To learn more about the `appTemplateBody` template, see the sample template provided in the *Examples* section.
         *
         * The `appTemplateBody` JSON string has the following structure:
         * + **`resources`**The list of logical resources that must be included in the Resilience Hub application.Type: ArrayDon't add the resources that you want to exclude.Each `resources` array item includes the following fields:
         *    + *`logicalResourceId`*Logical identifier of the resource.Type: ObjectEach `logicalResourceId` object includes the following fields:
         *       + `identifier`Identifier of the resource.Type: String
         *       + `logicalStackName`The name of the CloudFormation stack this resource belongs to.Type: String
         *       + `resourceGroupName`The name of the resource group this resource belongs to.Type: String
         *       + `terraformSourceName`The name of the Terraform S3 state file this resource belongs to.Type: String
         *       + `eksSourceName`Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.This parameter accepts values in "eks-cluster/namespace" format.Type: String
         *    + *`type`*The type of resource.Type: string
         *    + *`name`*The name of the resource.Type: String
         *    + `additionalInfo`Additional configuration parameters for an Resilience Hub application. If you want to implement `additionalInfo` through the Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.Key: `"failover-regions"`Value: `"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"`
         * + **`appComponents`**List of Application Components that this resource belongs to. If an Application Component is not part of the Resilience Hub application, it will be added.Type: ArrayEach `appComponents` array item includes the following fields:
         *    + `name`Name of the Application Component.Type: String
         *    + `type`Type of Application Component. For more information about the types of Application Component, see [Grouping resources in an AppComponent](https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html).Type: String
         *    + `resourceNames`The list of included resources that are assigned to the Application Component.Type: Array of strings
         *    + `additionalInfo`Additional configuration parameters for an Resilience Hub application. If you want to implement `additionalInfo` through the Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.Key: `"failover-regions"`Value: `"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"`
         * + **`excludedResources`**The list of logical resource identifiers to be excluded from the application.Type: ArrayDon't add the resources that you want to include.Each `excludedResources` array item includes the following fields:
         *    + *`logicalResourceIds`*Logical identifier of the resource.Type: ObjectYou can configure only one of the following fields:
         *       + `logicalStackName`
         *       + `resourceGroupName`
         *       + `terraformSourceName`
         *       + `eksSourceName`
         * Each `logicalResourceIds` object includes the following fields:
         *       + `identifier`Identifier of the resource.Type: String
         *       + `logicalStackName`The name of the CloudFormation stack this resource belongs to.Type: String
         *       + `resourceGroupName`The name of the resource group this resource belongs to.Type: String
         *       + `terraformSourceName`The name of the Terraform S3 state file this resource belongs to.Type: String
         *       + `eksSourceName`Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.This parameter accepts values in "eks-cluster/namespace" format.Type: String
         * + **`version`**Resilience Hub application version.
         * + `additionalInfo`Additional configuration parameters for an Resilience Hub application. If you want to implement `additionalInfo` through the Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.Key: `"failover-regions"`Value: `"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"`
         */
        public var appTemplateBody: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.PutDraftAppVersionTemplateRequest) : this() {
            this.appArn = x.appArn
            this.appTemplateBody = x.appTemplateBody
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.PutDraftAppVersionTemplateRequest = PutDraftAppVersionTemplateRequest(this)

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (appTemplateBody == null) appTemplateBody = ""
            return this
        }
    }
}
