// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified using an Amazon Resource Name (ARN) or an Resilience Hub-native identifier.
 */
public class PhysicalResource private constructor(builder: Builder) {
    /**
     * Additional configuration parameters for an Resilience Hub application. If you want to implement `additionalInfo` through the Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
     *
     * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
     *
     * Key: `"failover-regions"`
     *
     * Value: `"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"`
     */
    public val additionalInfo: Map<String, List<String>>? = builder.additionalInfo
    /**
     * The application components that belong to this resource.
     */
    public val appComponents: List<AppComponent>? = builder.appComponents
    /**
     * Indicates if a resource is included or excluded from the assessment.
     */
    public val excluded: kotlin.Boolean? = builder.excluded
    /**
     * Logical identifier of the resource.
     */
    public val logicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId? = builder.logicalResourceId
    /**
     * Name of the parent resource.
     */
    public val parentResourceName: kotlin.String? = builder.parentResourceName
    /**
     * Identifier of the physical resource.
     */
    public val physicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId? = builder.physicalResourceId
    /**
     * The name of the resource.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * Type of resource.
     */
    public val resourceType: kotlin.String = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }
    /**
     * Type of input source.
     */
    public val sourceType: aws.sdk.kotlin.services.resiliencehub.model.ResourceSourceType? = builder.sourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PhysicalResource(")
        append("additionalInfo=$additionalInfo,")
        append("appComponents=$appComponents,")
        append("excluded=$excluded,")
        append("logicalResourceId=$logicalResourceId,")
        append("parentResourceName=$parentResourceName,")
        append("physicalResourceId=$physicalResourceId,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType,")
        append("sourceType=$sourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (appComponents?.hashCode() ?: 0)
        result = 31 * result + (excluded?.hashCode() ?: 0)
        result = 31 * result + (logicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (parentResourceName?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceType.hashCode())
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PhysicalResource

        if (additionalInfo != other.additionalInfo) return false
        if (appComponents != other.appComponents) return false
        if (excluded != other.excluded) return false
        if (logicalResourceId != other.logicalResourceId) return false
        if (parentResourceName != other.parentResourceName) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Additional configuration parameters for an Resilience Hub application. If you want to implement `additionalInfo` through the Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
         *
         * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
         *
         * Key: `"failover-regions"`
         *
         * Value: `"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"`
         */
        public var additionalInfo: Map<String, List<String>>? = null
        /**
         * The application components that belong to this resource.
         */
        public var appComponents: List<AppComponent>? = null
        /**
         * Indicates if a resource is included or excluded from the assessment.
         */
        public var excluded: kotlin.Boolean? = null
        /**
         * Logical identifier of the resource.
         */
        public var logicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId? = null
        /**
         * Name of the parent resource.
         */
        public var parentResourceName: kotlin.String? = null
        /**
         * Identifier of the physical resource.
         */
        public var physicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId? = null
        /**
         * The name of the resource.
         */
        public var resourceName: kotlin.String? = null
        /**
         * Type of resource.
         */
        public var resourceType: kotlin.String? = null
        /**
         * Type of input source.
         */
        public var sourceType: aws.sdk.kotlin.services.resiliencehub.model.ResourceSourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource) : this() {
            this.additionalInfo = x.additionalInfo
            this.appComponents = x.appComponents
            this.excluded = x.excluded
            this.logicalResourceId = x.logicalResourceId
            this.parentResourceName = x.parentResourceName
            this.physicalResourceId = x.physicalResourceId
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
            this.sourceType = x.sourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource = PhysicalResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId] inside the given [block]
         */
        public fun logicalResourceId(block: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId.Builder.() -> kotlin.Unit) {
            this.logicalResourceId = aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId] inside the given [block]
         */
        public fun physicalResourceId(block: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId.Builder.() -> kotlin.Unit) {
            this.physicalResourceId = aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (resourceType == null) resourceType = ""
            return this
        }
    }
}
