// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class ListAppsRequest private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String? = builder.appArn
    /**
     * Amazon Resource Name (ARN) of Resource Groups group that is integrated with an AppRegistry application. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val awsApplicationArn: kotlin.String? = builder.awsApplicationArn
    /**
     * Lower limit of the range that is used to filter applications based on their last assessment times.
     */
    public val fromLastAssessmentTime: aws.smithy.kotlin.runtime.time.Instant? = builder.fromLastAssessmentTime
    /**
     * Maximum number of results to include in the response. If more results exist than the specified `MaxResults` value, a token is included in the response so that the remaining results can be retrieved.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The name for the one of the listed applications.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Null, or the token from a previous call to get the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The application list is sorted based on the values of `lastAppComplianceEvaluationTime` field. By default, application list is sorted in ascending order. To sort the application list in descending order, set this field to `True`.
     */
    public val reverseOrder: kotlin.Boolean? = builder.reverseOrder
    /**
     * Upper limit of the range that is used to filter the applications based on their last assessment times.
     */
    public val toLastAssessmentTime: aws.smithy.kotlin.runtime.time.Instant? = builder.toLastAssessmentTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.ListAppsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAppsRequest(")
        append("appArn=$appArn,")
        append("awsApplicationArn=$awsApplicationArn,")
        append("fromLastAssessmentTime=$fromLastAssessmentTime,")
        append("maxResults=$maxResults,")
        append("name=$name,")
        append("nextToken=$nextToken,")
        append("reverseOrder=$reverseOrder,")
        append("toLastAssessmentTime=$toLastAssessmentTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn?.hashCode() ?: 0
        result = 31 * result + (awsApplicationArn?.hashCode() ?: 0)
        result = 31 * result + (fromLastAssessmentTime?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (reverseOrder?.hashCode() ?: 0)
        result = 31 * result + (toLastAssessmentTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAppsRequest

        if (appArn != other.appArn) return false
        if (awsApplicationArn != other.awsApplicationArn) return false
        if (fromLastAssessmentTime != other.fromLastAssessmentTime) return false
        if (maxResults != other.maxResults) return false
        if (name != other.name) return false
        if (nextToken != other.nextToken) return false
        if (reverseOrder != other.reverseOrder) return false
        if (toLastAssessmentTime != other.toLastAssessmentTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.ListAppsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Amazon Resource Name (ARN) of Resource Groups group that is integrated with an AppRegistry application. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var awsApplicationArn: kotlin.String? = null
        /**
         * Lower limit of the range that is used to filter applications based on their last assessment times.
         */
        public var fromLastAssessmentTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Maximum number of results to include in the response. If more results exist than the specified `MaxResults` value, a token is included in the response so that the remaining results can be retrieved.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The name for the one of the listed applications.
         */
        public var name: kotlin.String? = null
        /**
         * Null, or the token from a previous call to get the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The application list is sorted based on the values of `lastAppComplianceEvaluationTime` field. By default, application list is sorted in ascending order. To sort the application list in descending order, set this field to `True`.
         */
        public var reverseOrder: kotlin.Boolean? = null
        /**
         * Upper limit of the range that is used to filter the applications based on their last assessment times.
         */
        public var toLastAssessmentTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.ListAppsRequest) : this() {
            this.appArn = x.appArn
            this.awsApplicationArn = x.awsApplicationArn
            this.fromLastAssessmentTime = x.fromLastAssessmentTime
            this.maxResults = x.maxResults
            this.name = x.name
            this.nextToken = x.nextToken
            this.reverseOrder = x.reverseOrder
            this.toLastAssessmentTime = x.toLastAssessmentTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.ListAppsRequest = ListAppsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
