// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ImportResourcesToDraftAppVersionResponse private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * The version of the application.
     */
    public val appVersion: kotlin.String = requireNotNull(builder.appVersion) { "A non-null value must be provided for appVersion" }
    /**
     * The input sources of the Amazon Elastic Kubernetes Service resources you have imported.
     */
    public val eksSources: List<EksSource>? = builder.eksSources
    /**
     * The Amazon Resource Names (ARNs) for the resources you have imported.
     */
    public val sourceArns: List<String>? = builder.sourceArns
    /**
     * Status of the action.
     */
    public val status: aws.sdk.kotlin.services.resiliencehub.model.ResourceImportStatusType = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * A list of terraform file s3 URLs you have imported.
     */
    public val terraformSources: List<TerraformSource>? = builder.terraformSources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportResourcesToDraftAppVersionResponse(")
        append("appArn=$appArn,")
        append("appVersion=$appVersion,")
        append("eksSources=$eksSources,")
        append("sourceArns=$sourceArns,")
        append("status=$status,")
        append("terraformSources=$terraformSources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (appVersion.hashCode())
        result = 31 * result + (eksSources?.hashCode() ?: 0)
        result = 31 * result + (sourceArns?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (terraformSources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportResourcesToDraftAppVersionResponse

        if (appArn != other.appArn) return false
        if (appVersion != other.appVersion) return false
        if (eksSources != other.eksSources) return false
        if (sourceArns != other.sourceArns) return false
        if (status != other.status) return false
        if (terraformSources != other.terraformSources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * The version of the application.
         */
        public var appVersion: kotlin.String? = null
        /**
         * The input sources of the Amazon Elastic Kubernetes Service resources you have imported.
         */
        public var eksSources: List<EksSource>? = null
        /**
         * The Amazon Resource Names (ARNs) for the resources you have imported.
         */
        public var sourceArns: List<String>? = null
        /**
         * Status of the action.
         */
        public var status: aws.sdk.kotlin.services.resiliencehub.model.ResourceImportStatusType? = null
        /**
         * A list of terraform file s3 URLs you have imported.
         */
        public var terraformSources: List<TerraformSource>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionResponse) : this() {
            this.appArn = x.appArn
            this.appVersion = x.appVersion
            this.eksSources = x.eksSources
            this.sourceArns = x.sourceArns
            this.status = x.status
            this.terraformSources = x.terraformSources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionResponse = ImportResourcesToDraftAppVersionResponse(this)

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (appVersion == null) appVersion = ""
            if (status == null) status = ResourceImportStatusType.SdkUnknown("no value provided")
            return this
        }
    }
}
