// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ImportResourcesToDraftAppVersionRequest private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * The input sources of the Amazon Elastic Kubernetes Service resources you need to import.
     */
    public val eksSources: List<EksSource>? = builder.eksSources
    /**
     * The import strategy you would like to set to import resources into Resilience Hub application.
     */
    public val importStrategy: aws.sdk.kotlin.services.resiliencehub.model.ResourceImportStrategyType? = builder.importStrategy
    /**
     * The Amazon Resource Names (ARNs) for the resources.
     */
    public val sourceArns: List<String>? = builder.sourceArns
    /**
     * A list of terraform file s3 URLs you need to import.
     */
    public val terraformSources: List<TerraformSource>? = builder.terraformSources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportResourcesToDraftAppVersionRequest(")
        append("appArn=$appArn,")
        append("eksSources=$eksSources,")
        append("importStrategy=$importStrategy,")
        append("sourceArns=$sourceArns,")
        append("terraformSources=$terraformSources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (eksSources?.hashCode() ?: 0)
        result = 31 * result + (importStrategy?.hashCode() ?: 0)
        result = 31 * result + (sourceArns?.hashCode() ?: 0)
        result = 31 * result + (terraformSources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportResourcesToDraftAppVersionRequest

        if (appArn != other.appArn) return false
        if (eksSources != other.eksSources) return false
        if (importStrategy != other.importStrategy) return false
        if (sourceArns != other.sourceArns) return false
        if (terraformSources != other.terraformSources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * The input sources of the Amazon Elastic Kubernetes Service resources you need to import.
         */
        public var eksSources: List<EksSource>? = null
        /**
         * The import strategy you would like to set to import resources into Resilience Hub application.
         */
        public var importStrategy: aws.sdk.kotlin.services.resiliencehub.model.ResourceImportStrategyType? = null
        /**
         * The Amazon Resource Names (ARNs) for the resources.
         */
        public var sourceArns: List<String>? = null
        /**
         * A list of terraform file s3 URLs you need to import.
         */
        public var terraformSources: List<TerraformSource>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionRequest) : this() {
            this.appArn = x.appArn
            this.eksSources = x.eksSources
            this.importStrategy = x.importStrategy
            this.sourceArns = x.sourceArns
            this.terraformSources = x.terraformSources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionRequest = ImportResourcesToDraftAppVersionRequest(this)

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            return this
        }
    }
}
