// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeDraftAppVersionResourcesImportStatusResponse private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * The version of the application.
     */
    public val appVersion: kotlin.String = requireNotNull(builder.appVersion) { "A non-null value must be provided for appVersion" }
    /**
     * List of errors that were encountered while importing resources.
     */
    public val errorDetails: List<ErrorDetail>? = builder.errorDetails
    /**
     * The error message returned for the resource request.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * Status of the action.
     */
    public val status: aws.sdk.kotlin.services.resiliencehub.model.ResourceImportStatusType = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The time when the status last changed.
     */
    public val statusChangeTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.statusChangeTime) { "A non-null value must be provided for statusChangeTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDraftAppVersionResourcesImportStatusResponse(")
        append("appArn=$appArn,")
        append("appVersion=$appVersion,")
        append("errorDetails=$errorDetails,")
        append("errorMessage=$errorMessage,")
        append("status=$status,")
        append("statusChangeTime=$statusChangeTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (appVersion.hashCode())
        result = 31 * result + (errorDetails?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (statusChangeTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDraftAppVersionResourcesImportStatusResponse

        if (appArn != other.appArn) return false
        if (appVersion != other.appVersion) return false
        if (errorDetails != other.errorDetails) return false
        if (errorMessage != other.errorMessage) return false
        if (status != other.status) return false
        if (statusChangeTime != other.statusChangeTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * The version of the application.
         */
        public var appVersion: kotlin.String? = null
        /**
         * List of errors that were encountered while importing resources.
         */
        public var errorDetails: List<ErrorDetail>? = null
        /**
         * The error message returned for the resource request.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * Status of the action.
         */
        public var status: aws.sdk.kotlin.services.resiliencehub.model.ResourceImportStatusType? = null
        /**
         * The time when the status last changed.
         */
        public var statusChangeTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusResponse) : this() {
            this.appArn = x.appArn
            this.appVersion = x.appVersion
            this.errorDetails = x.errorDetails
            this.errorMessage = x.errorMessage
            this.status = x.status
            this.statusChangeTime = x.statusChangeTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusResponse = DescribeDraftAppVersionResourcesImportStatusResponse(this)

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (appVersion == null) appVersion = ""
            if (status == null) status = ResourceImportStatusType.SdkUnknown("no value provided")
            if (statusChangeTime == null) statusChangeTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
