// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DeleteAppVersionResourceRequest private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * Amazon Web Services account that owns the physical resource.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * Amazon Web Services region that owns the physical resource.
     */
    public val awsRegion: kotlin.String? = builder.awsRegion
    /**
     * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Logical identifier of the resource.
     */
    public val logicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId? = builder.logicalResourceId
    /**
     * Physical identifier of the resource.
     */
    public val physicalResourceId: kotlin.String? = builder.physicalResourceId
    /**
     * Name of the resource.
     */
    public val resourceName: kotlin.String? = builder.resourceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.DeleteAppVersionResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteAppVersionResourceRequest(")
        append("appArn=$appArn,")
        append("awsAccountId=$awsAccountId,")
        append("awsRegion=$awsRegion,")
        append("clientToken=$clientToken,")
        append("logicalResourceId=$logicalResourceId,")
        append("physicalResourceId=$physicalResourceId,")
        append("resourceName=$resourceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (awsRegion?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (logicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteAppVersionResourceRequest

        if (appArn != other.appArn) return false
        if (awsAccountId != other.awsAccountId) return false
        if (awsRegion != other.awsRegion) return false
        if (clientToken != other.clientToken) return false
        if (logicalResourceId != other.logicalResourceId) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (resourceName != other.resourceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.DeleteAppVersionResourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Amazon Web Services account that owns the physical resource.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * Amazon Web Services region that owns the physical resource.
         */
        public var awsRegion: kotlin.String? = null
        /**
         * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Logical identifier of the resource.
         */
        public var logicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId? = null
        /**
         * Physical identifier of the resource.
         */
        public var physicalResourceId: kotlin.String? = null
        /**
         * Name of the resource.
         */
        public var resourceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.DeleteAppVersionResourceRequest) : this() {
            this.appArn = x.appArn
            this.awsAccountId = x.awsAccountId
            this.awsRegion = x.awsRegion
            this.clientToken = x.clientToken
            this.logicalResourceId = x.logicalResourceId
            this.physicalResourceId = x.physicalResourceId
            this.resourceName = x.resourceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.DeleteAppVersionResourceRequest = DeleteAppVersionResourceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId] inside the given [block]
         */
        public fun logicalResourceId(block: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId.Builder.() -> kotlin.Unit) {
            this.logicalResourceId = aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            return this
        }
    }
}
