// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAppRequest private constructor(builder: Builder) {
    /**
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     */
    public val assessmentSchedule: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentScheduleType? = builder.assessmentSchedule
    /**
     * Amazon Resource Name (ARN) of Resource Groups group that is integrated with an AppRegistry application. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val awsApplicationArn: kotlin.String? = builder.awsApplicationArn
    /**
     * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The optional description for an app.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports only **Drift detected** and **Scheduled assessment failure** events notification.
     */
    public val eventSubscriptions: List<EventSubscription>? = builder.eventSubscriptions
    /**
     * Name of the application.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Defines the roles and credentials that Resilience Hub would use while creating the application, importing its resources, and running an assessment.
     */
    public val permissionModel: aws.sdk.kotlin.services.resiliencehub.model.PermissionModel? = builder.permissionModel
    /**
     * Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val policyArn: kotlin.String? = builder.policyArn
    /**
     * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.CreateAppRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAppRequest(")
        append("assessmentSchedule=$assessmentSchedule,")
        append("awsApplicationArn=$awsApplicationArn,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("eventSubscriptions=$eventSubscriptions,")
        append("name=$name,")
        append("permissionModel=$permissionModel,")
        append("policyArn=$policyArn,")
        append("tags=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentSchedule?.hashCode() ?: 0
        result = 31 * result + (awsApplicationArn?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eventSubscriptions?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (permissionModel?.hashCode() ?: 0)
        result = 31 * result + (policyArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAppRequest

        if (assessmentSchedule != other.assessmentSchedule) return false
        if (awsApplicationArn != other.awsApplicationArn) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (eventSubscriptions != other.eventSubscriptions) return false
        if (name != other.name) return false
        if (permissionModel != other.permissionModel) return false
        if (policyArn != other.policyArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.CreateAppRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         */
        public var assessmentSchedule: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentScheduleType? = null
        /**
         * Amazon Resource Name (ARN) of Resource Groups group that is integrated with an AppRegistry application. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var awsApplicationArn: kotlin.String? = null
        /**
         * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The optional description for an app.
         */
        public var description: kotlin.String? = null
        /**
         * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports only **Drift detected** and **Scheduled assessment failure** events notification.
         */
        public var eventSubscriptions: List<EventSubscription>? = null
        /**
         * Name of the application.
         */
        public var name: kotlin.String? = null
        /**
         * Defines the roles and credentials that Resilience Hub would use while creating the application, importing its resources, and running an assessment.
         */
        public var permissionModel: aws.sdk.kotlin.services.resiliencehub.model.PermissionModel? = null
        /**
         * Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var policyArn: kotlin.String? = null
        /**
         * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.CreateAppRequest) : this() {
            this.assessmentSchedule = x.assessmentSchedule
            this.awsApplicationArn = x.awsApplicationArn
            this.clientToken = x.clientToken
            this.description = x.description
            this.eventSubscriptions = x.eventSubscriptions
            this.name = x.name
            this.permissionModel = x.permissionModel
            this.policyArn = x.policyArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.CreateAppRequest = CreateAppRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.PermissionModel] inside the given [block]
         */
        public fun permissionModel(block: aws.sdk.kotlin.services.resiliencehub.model.PermissionModel.Builder.() -> kotlin.Unit) {
            this.permissionModel = aws.sdk.kotlin.services.resiliencehub.model.PermissionModel.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            return this
        }
    }
}
