// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines recommendations for an Resilience Hub Application Component, returned as an object. This object contains component names, configuration recommendations, and recommendation statuses.
 */
public class ComponentRecommendation private constructor(builder: Builder) {
    /**
     * Name of the Application Component.
     */
    public val appComponentName: kotlin.String = requireNotNull(builder.appComponentName) { "A non-null value must be provided for appComponentName" }
    /**
     * List of recommendations.
     */
    public val configRecommendations: List<ConfigRecommendation> = requireNotNull(builder.configRecommendations) { "A non-null value must be provided for configRecommendations" }
    /**
     * Status of the recommendation.
     */
    public val recommendationStatus: aws.sdk.kotlin.services.resiliencehub.model.RecommendationComplianceStatus = requireNotNull(builder.recommendationStatus) { "A non-null value must be provided for recommendationStatus" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.ComponentRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComponentRecommendation(")
        append("appComponentName=$appComponentName,")
        append("configRecommendations=$configRecommendations,")
        append("recommendationStatus=$recommendationStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appComponentName.hashCode()
        result = 31 * result + (configRecommendations.hashCode())
        result = 31 * result + (recommendationStatus.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComponentRecommendation

        if (appComponentName != other.appComponentName) return false
        if (configRecommendations != other.configRecommendations) return false
        if (recommendationStatus != other.recommendationStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.ComponentRecommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Name of the Application Component.
         */
        public var appComponentName: kotlin.String? = null
        /**
         * List of recommendations.
         */
        public var configRecommendations: List<ConfigRecommendation>? = null
        /**
         * Status of the recommendation.
         */
        public var recommendationStatus: aws.sdk.kotlin.services.resiliencehub.model.RecommendationComplianceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.ComponentRecommendation) : this() {
            this.appComponentName = x.appComponentName
            this.configRecommendations = x.configRecommendations
            this.recommendationStatus = x.recommendationStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.ComponentRecommendation = ComponentRecommendation(this)

        internal fun correctErrors(): Builder {
            if (appComponentName == null) appComponentName = ""
            if (configRecommendations == null) configRecommendations = emptyList()
            if (recommendationStatus == null) recommendationStatus = RecommendationComplianceStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
