// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The list of Resilience Hub application input sources.
 */
public class AppInputSource private constructor(builder: Builder) {
    /**
     * The namespace on your Amazon Elastic Kubernetes Service cluster.
     */
    public val eksSourceClusterNamespace: aws.sdk.kotlin.services.resiliencehub.model.EksSourceClusterNamespace? = builder.eksSourceClusterNamespace
    /**
     * The resource type of the input source.
     */
    public val importType: aws.sdk.kotlin.services.resiliencehub.model.ResourceMappingType = requireNotNull(builder.importType) { "A non-null value must be provided for importType" }
    /**
     * The number of resources.
     */
    public val resourceCount: kotlin.Int = builder.resourceCount
    /**
     * The Amazon Resource Name (ARN) of the input source. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * The name of the input source.
     */
    public val sourceName: kotlin.String? = builder.sourceName
    /**
     * The name of the Terraform s3 state ﬁle.
     */
    public val terraformSource: aws.sdk.kotlin.services.resiliencehub.model.TerraformSource? = builder.terraformSource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.AppInputSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppInputSource(")
        append("eksSourceClusterNamespace=$eksSourceClusterNamespace,")
        append("importType=$importType,")
        append("resourceCount=$resourceCount,")
        append("sourceArn=$sourceArn,")
        append("sourceName=$sourceName,")
        append("terraformSource=$terraformSource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eksSourceClusterNamespace?.hashCode() ?: 0
        result = 31 * result + (importType.hashCode())
        result = 31 * result + (resourceCount)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (sourceName?.hashCode() ?: 0)
        result = 31 * result + (terraformSource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppInputSource

        if (eksSourceClusterNamespace != other.eksSourceClusterNamespace) return false
        if (importType != other.importType) return false
        if (resourceCount != other.resourceCount) return false
        if (sourceArn != other.sourceArn) return false
        if (sourceName != other.sourceName) return false
        if (terraformSource != other.terraformSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.AppInputSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The namespace on your Amazon Elastic Kubernetes Service cluster.
         */
        public var eksSourceClusterNamespace: aws.sdk.kotlin.services.resiliencehub.model.EksSourceClusterNamespace? = null
        /**
         * The resource type of the input source.
         */
        public var importType: aws.sdk.kotlin.services.resiliencehub.model.ResourceMappingType? = null
        /**
         * The number of resources.
         */
        public var resourceCount: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the input source. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * The name of the input source.
         */
        public var sourceName: kotlin.String? = null
        /**
         * The name of the Terraform s3 state ﬁle.
         */
        public var terraformSource: aws.sdk.kotlin.services.resiliencehub.model.TerraformSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.AppInputSource) : this() {
            this.eksSourceClusterNamespace = x.eksSourceClusterNamespace
            this.importType = x.importType
            this.resourceCount = x.resourceCount
            this.sourceArn = x.sourceArn
            this.sourceName = x.sourceName
            this.terraformSource = x.terraformSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.AppInputSource = AppInputSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.EksSourceClusterNamespace] inside the given [block]
         */
        public fun eksSourceClusterNamespace(block: aws.sdk.kotlin.services.resiliencehub.model.EksSourceClusterNamespace.Builder.() -> kotlin.Unit) {
            this.eksSourceClusterNamespace = aws.sdk.kotlin.services.resiliencehub.model.EksSourceClusterNamespace.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.TerraformSource] inside the given [block]
         */
        public fun terraformSource(block: aws.sdk.kotlin.services.resiliencehub.model.TerraformSource.Builder.() -> kotlin.Unit) {
            this.terraformSource = aws.sdk.kotlin.services.resiliencehub.model.TerraformSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (importType == null) importType = ResourceMappingType.SdkUnknown("no value provided")
            return this
        }
    }
}
