// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines an Application Component.
 */
public class AppComponent private constructor(builder: Builder) {
    /**
     * Additional configuration parameters for an Resilience Hub application. If you want to implement `additionalInfo` through the Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
     *
     * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
     *
     * Key: `"failover-regions"`
     *
     * Value: `"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"`
     */
    public val additionalInfo: Map<String, List<String>>? = builder.additionalInfo
    /**
     * Identifier of the Application Component.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Name of the Application Component.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The type of Application Component.
     */
    public val type: kotlin.String = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.AppComponent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppComponent(")
        append("additionalInfo=$additionalInfo,")
        append("id=$id,")
        append("name=$name,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppComponent

        if (additionalInfo != other.additionalInfo) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.AppComponent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Additional configuration parameters for an Resilience Hub application. If you want to implement `additionalInfo` through the Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
         *
         * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
         *
         * Key: `"failover-regions"`
         *
         * Value: `"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"`
         */
        public var additionalInfo: Map<String, List<String>>? = null
        /**
         * Identifier of the Application Component.
         */
        public var id: kotlin.String? = null
        /**
         * Name of the Application Component.
         */
        public var name: kotlin.String? = null
        /**
         * The type of Application Component.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.AppComponent) : this() {
            this.additionalInfo = x.additionalInfo
            this.id = x.id
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.AppComponent = AppComponent(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (type == null) type = ""
            return this
        }
    }
}
