// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Defines an application assessment.
 */
public class AppAssessment private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String? = builder.appArn
    /**
     * Version of an application.
     */
    public val appVersion: kotlin.String? = builder.appVersion
    /**
     * Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val assessmentArn: kotlin.String = requireNotNull(builder.assessmentArn) { "A non-null value must be provided for assessmentArn" }
    /**
     * Name of the assessment.
     */
    public val assessmentName: kotlin.String? = builder.assessmentName
    /**
     * Current status of the assessment for the resiliency policy.
     */
    public val assessmentStatus: aws.sdk.kotlin.services.resiliencehub.model.AssessmentStatus = requireNotNull(builder.assessmentStatus) { "A non-null value must be provided for assessmentStatus" }
    /**
     * Application compliance against the resiliency policy.
     */
    public val compliance: Map<DisruptionType, DisruptionCompliance>? = builder.compliance
    /**
     * Current status of the compliance for the resiliency policy.
     */
    public val complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.ComplianceStatus? = builder.complianceStatus
    /**
     * Cost for the application.
     */
    public val cost: aws.sdk.kotlin.services.resiliencehub.model.Cost? = builder.cost
    /**
     * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
     */
    public val driftStatus: aws.sdk.kotlin.services.resiliencehub.model.DriftStatus? = builder.driftStatus
    /**
     * End time for the action.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The entity that invoked the assessment.
     */
    public val invoker: aws.sdk.kotlin.services.resiliencehub.model.AssessmentInvoker = requireNotNull(builder.invoker) { "A non-null value must be provided for invoker" }
    /**
     * Error or warning message from the assessment execution
     */
    public val message: kotlin.String? = builder.message
    /**
     * Resiliency policy of an application.
     */
    public val policy: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicy? = builder.policy
    /**
     * Current resiliency score for an application.
     */
    public val resiliencyScore: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyScore? = builder.resiliencyScore
    /**
     * A resource error object containing a list of errors retrieving an application's resources.
     */
    public val resourceErrorsDetails: aws.sdk.kotlin.services.resiliencehub.model.ResourceErrorsDetails? = builder.resourceErrorsDetails
    /**
     * Starting time for the action.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Indicates the AI-generated summary for the Resilience Hub assessment, providing a concise overview that highlights the top risks and recommendations.
     *
     * This property is available only in the US East (N. Virginia) Region.
     */
    public val summary: aws.sdk.kotlin.services.resiliencehub.model.AssessmentSummary? = builder.summary
    /**
     * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Version name of the published application.
     */
    public val versionName: kotlin.String? = builder.versionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.AppAssessment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppAssessment(")
        append("appArn=$appArn,")
        append("appVersion=$appVersion,")
        append("assessmentArn=$assessmentArn,")
        append("assessmentName=$assessmentName,")
        append("assessmentStatus=$assessmentStatus,")
        append("compliance=$compliance,")
        append("complianceStatus=$complianceStatus,")
        append("cost=$cost,")
        append("driftStatus=$driftStatus,")
        append("endTime=$endTime,")
        append("invoker=$invoker,")
        append("message=$message,")
        append("policy=$policy,")
        append("resiliencyScore=$resiliencyScore,")
        append("resourceErrorsDetails=$resourceErrorsDetails,")
        append("startTime=$startTime,")
        append("summary=$summary,")
        append("tags=*** Sensitive Data Redacted ***,")
        append("versionName=$versionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn?.hashCode() ?: 0
        result = 31 * result + (appVersion?.hashCode() ?: 0)
        result = 31 * result + (assessmentArn.hashCode())
        result = 31 * result + (assessmentName?.hashCode() ?: 0)
        result = 31 * result + (assessmentStatus.hashCode())
        result = 31 * result + (compliance?.hashCode() ?: 0)
        result = 31 * result + (complianceStatus?.hashCode() ?: 0)
        result = 31 * result + (cost?.hashCode() ?: 0)
        result = 31 * result + (driftStatus?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (invoker.hashCode())
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (resiliencyScore?.hashCode() ?: 0)
        result = 31 * result + (resourceErrorsDetails?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (summary?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppAssessment

        if (appArn != other.appArn) return false
        if (appVersion != other.appVersion) return false
        if (assessmentArn != other.assessmentArn) return false
        if (assessmentName != other.assessmentName) return false
        if (assessmentStatus != other.assessmentStatus) return false
        if (compliance != other.compliance) return false
        if (complianceStatus != other.complianceStatus) return false
        if (cost != other.cost) return false
        if (driftStatus != other.driftStatus) return false
        if (endTime != other.endTime) return false
        if (invoker != other.invoker) return false
        if (message != other.message) return false
        if (policy != other.policy) return false
        if (resiliencyScore != other.resiliencyScore) return false
        if (resourceErrorsDetails != other.resourceErrorsDetails) return false
        if (startTime != other.startTime) return false
        if (summary != other.summary) return false
        if (tags != other.tags) return false
        if (versionName != other.versionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.AppAssessment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Version of an application.
         */
        public var appVersion: kotlin.String? = null
        /**
         * Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var assessmentArn: kotlin.String? = null
        /**
         * Name of the assessment.
         */
        public var assessmentName: kotlin.String? = null
        /**
         * Current status of the assessment for the resiliency policy.
         */
        public var assessmentStatus: aws.sdk.kotlin.services.resiliencehub.model.AssessmentStatus? = null
        /**
         * Application compliance against the resiliency policy.
         */
        public var compliance: Map<DisruptionType, DisruptionCompliance>? = null
        /**
         * Current status of the compliance for the resiliency policy.
         */
        public var complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.ComplianceStatus? = null
        /**
         * Cost for the application.
         */
        public var cost: aws.sdk.kotlin.services.resiliencehub.model.Cost? = null
        /**
         * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
         */
        public var driftStatus: aws.sdk.kotlin.services.resiliencehub.model.DriftStatus? = null
        /**
         * End time for the action.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The entity that invoked the assessment.
         */
        public var invoker: aws.sdk.kotlin.services.resiliencehub.model.AssessmentInvoker? = null
        /**
         * Error or warning message from the assessment execution
         */
        public var message: kotlin.String? = null
        /**
         * Resiliency policy of an application.
         */
        public var policy: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicy? = null
        /**
         * Current resiliency score for an application.
         */
        public var resiliencyScore: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyScore? = null
        /**
         * A resource error object containing a list of errors retrieving an application's resources.
         */
        public var resourceErrorsDetails: aws.sdk.kotlin.services.resiliencehub.model.ResourceErrorsDetails? = null
        /**
         * Starting time for the action.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates the AI-generated summary for the Resilience Hub assessment, providing a concise overview that highlights the top risks and recommendations.
         *
         * This property is available only in the US East (N. Virginia) Region.
         */
        public var summary: aws.sdk.kotlin.services.resiliencehub.model.AssessmentSummary? = null
        /**
         * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
         */
        public var tags: Map<String, String>? = null
        /**
         * Version name of the published application.
         */
        public var versionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.AppAssessment) : this() {
            this.appArn = x.appArn
            this.appVersion = x.appVersion
            this.assessmentArn = x.assessmentArn
            this.assessmentName = x.assessmentName
            this.assessmentStatus = x.assessmentStatus
            this.compliance = x.compliance
            this.complianceStatus = x.complianceStatus
            this.cost = x.cost
            this.driftStatus = x.driftStatus
            this.endTime = x.endTime
            this.invoker = x.invoker
            this.message = x.message
            this.policy = x.policy
            this.resiliencyScore = x.resiliencyScore
            this.resourceErrorsDetails = x.resourceErrorsDetails
            this.startTime = x.startTime
            this.summary = x.summary
            this.tags = x.tags
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.AppAssessment = AppAssessment(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.Cost] inside the given [block]
         */
        public fun cost(block: aws.sdk.kotlin.services.resiliencehub.model.Cost.Builder.() -> kotlin.Unit) {
            this.cost = aws.sdk.kotlin.services.resiliencehub.model.Cost.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicy] inside the given [block]
         */
        public fun policy(block: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicy.Builder.() -> kotlin.Unit) {
            this.policy = aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.ResiliencyScore] inside the given [block]
         */
        public fun resiliencyScore(block: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyScore.Builder.() -> kotlin.Unit) {
            this.resiliencyScore = aws.sdk.kotlin.services.resiliencehub.model.ResiliencyScore.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.ResourceErrorsDetails] inside the given [block]
         */
        public fun resourceErrorsDetails(block: aws.sdk.kotlin.services.resiliencehub.model.ResourceErrorsDetails.Builder.() -> kotlin.Unit) {
            this.resourceErrorsDetails = aws.sdk.kotlin.services.resiliencehub.model.ResourceErrorsDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.AssessmentSummary] inside the given [block]
         */
        public fun summary(block: aws.sdk.kotlin.services.resiliencehub.model.AssessmentSummary.Builder.() -> kotlin.Unit) {
            this.summary = aws.sdk.kotlin.services.resiliencehub.model.AssessmentSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (assessmentArn == null) assessmentArn = ""
            if (assessmentStatus == null) assessmentStatus = AssessmentStatus.SdkUnknown("no value provided")
            if (invoker == null) invoker = AssessmentInvoker.SdkUnknown("no value provided")
            return this
        }
    }
}
