// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Defines an Resilience Hub application.
 */
public class App private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     */
    public val assessmentSchedule: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentScheduleType? = builder.assessmentSchedule
    /**
     * Amazon Resource Name (ARN) of Resource Groups group that is integrated with an AppRegistry application. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val awsApplicationArn: kotlin.String? = builder.awsApplicationArn
    /**
     * Current status of compliance for the resiliency policy.
     */
    public val complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.AppComplianceStatusType? = builder.complianceStatus
    /**
     * Date and time when the application was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * Optional description for an application.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
     */
    public val driftStatus: aws.sdk.kotlin.services.resiliencehub.model.AppDriftStatusType? = builder.driftStatus
    /**
     * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports notifications only for **Drift detected** and **Scheduled assessment failure** events.
     */
    public val eventSubscriptions: List<EventSubscription>? = builder.eventSubscriptions
    /**
     * Date and time the most recent compliance evaluation.
     */
    public val lastAppComplianceEvaluationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAppComplianceEvaluationTime
    /**
     * Indicates the last time that a drift was evaluated.
     */
    public val lastDriftEvaluationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDriftEvaluationTime
    /**
     * Date and time the most recent resiliency score evaluation.
     */
    public val lastResiliencyScoreEvaluationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastResiliencyScoreEvaluationTime
    /**
     * Name for the application.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Defines the roles and credentials that Resilience Hub would use while creating the application, importing its resources, and running an assessment.
     */
    public val permissionModel: aws.sdk.kotlin.services.resiliencehub.model.PermissionModel? = builder.permissionModel
    /**
     * Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val policyArn: kotlin.String? = builder.policyArn
    /**
     * Current resiliency score for the application.
     */
    public val resiliencyScore: kotlin.Double = builder.resiliencyScore
    /**
     * Recovery Point Objective (RPO) in seconds.
     */
    public val rpoInSecs: kotlin.Int? = builder.rpoInSecs
    /**
     * Recovery Time Objective (RTO) in seconds.
     */
    public val rtoInSecs: kotlin.Int? = builder.rtoInSecs
    /**
     * Status of the application.
     */
    public val status: aws.sdk.kotlin.services.resiliencehub.model.AppStatusType? = builder.status
    /**
     * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.App = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("App(")
        append("appArn=$appArn,")
        append("assessmentSchedule=$assessmentSchedule,")
        append("awsApplicationArn=$awsApplicationArn,")
        append("complianceStatus=$complianceStatus,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("driftStatus=$driftStatus,")
        append("eventSubscriptions=$eventSubscriptions,")
        append("lastAppComplianceEvaluationTime=$lastAppComplianceEvaluationTime,")
        append("lastDriftEvaluationTime=$lastDriftEvaluationTime,")
        append("lastResiliencyScoreEvaluationTime=$lastResiliencyScoreEvaluationTime,")
        append("name=$name,")
        append("permissionModel=$permissionModel,")
        append("policyArn=$policyArn,")
        append("resiliencyScore=$resiliencyScore,")
        append("rpoInSecs=$rpoInSecs,")
        append("rtoInSecs=$rtoInSecs,")
        append("status=$status,")
        append("tags=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (assessmentSchedule?.hashCode() ?: 0)
        result = 31 * result + (awsApplicationArn?.hashCode() ?: 0)
        result = 31 * result + (complianceStatus?.hashCode() ?: 0)
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (driftStatus?.hashCode() ?: 0)
        result = 31 * result + (eventSubscriptions?.hashCode() ?: 0)
        result = 31 * result + (lastAppComplianceEvaluationTime?.hashCode() ?: 0)
        result = 31 * result + (lastDriftEvaluationTime?.hashCode() ?: 0)
        result = 31 * result + (lastResiliencyScoreEvaluationTime?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (permissionModel?.hashCode() ?: 0)
        result = 31 * result + (policyArn?.hashCode() ?: 0)
        result = 31 * result + (resiliencyScore.hashCode())
        result = 31 * result + (rpoInSecs ?: 0)
        result = 31 * result + (rtoInSecs ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as App

        if (appArn != other.appArn) return false
        if (assessmentSchedule != other.assessmentSchedule) return false
        if (awsApplicationArn != other.awsApplicationArn) return false
        if (complianceStatus != other.complianceStatus) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (driftStatus != other.driftStatus) return false
        if (eventSubscriptions != other.eventSubscriptions) return false
        if (lastAppComplianceEvaluationTime != other.lastAppComplianceEvaluationTime) return false
        if (lastDriftEvaluationTime != other.lastDriftEvaluationTime) return false
        if (lastResiliencyScoreEvaluationTime != other.lastResiliencyScoreEvaluationTime) return false
        if (name != other.name) return false
        if (permissionModel != other.permissionModel) return false
        if (policyArn != other.policyArn) return false
        if (!(resiliencyScore?.equals(other.resiliencyScore) ?: (other.resiliencyScore == null))) return false
        if (rpoInSecs != other.rpoInSecs) return false
        if (rtoInSecs != other.rtoInSecs) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.App = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         */
        public var assessmentSchedule: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentScheduleType? = null
        /**
         * Amazon Resource Name (ARN) of Resource Groups group that is integrated with an AppRegistry application. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var awsApplicationArn: kotlin.String? = null
        /**
         * Current status of compliance for the resiliency policy.
         */
        public var complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.AppComplianceStatusType? = null
        /**
         * Date and time when the application was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Optional description for an application.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
         */
        public var driftStatus: aws.sdk.kotlin.services.resiliencehub.model.AppDriftStatusType? = null
        /**
         * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports notifications only for **Drift detected** and **Scheduled assessment failure** events.
         */
        public var eventSubscriptions: List<EventSubscription>? = null
        /**
         * Date and time the most recent compliance evaluation.
         */
        public var lastAppComplianceEvaluationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates the last time that a drift was evaluated.
         */
        public var lastDriftEvaluationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Date and time the most recent resiliency score evaluation.
         */
        public var lastResiliencyScoreEvaluationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Name for the application.
         */
        public var name: kotlin.String? = null
        /**
         * Defines the roles and credentials that Resilience Hub would use while creating the application, importing its resources, and running an assessment.
         */
        public var permissionModel: aws.sdk.kotlin.services.resiliencehub.model.PermissionModel? = null
        /**
         * Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var policyArn: kotlin.String? = null
        /**
         * Current resiliency score for the application.
         */
        public var resiliencyScore: kotlin.Double = 0.0
        /**
         * Recovery Point Objective (RPO) in seconds.
         */
        public var rpoInSecs: kotlin.Int? = null
        /**
         * Recovery Time Objective (RTO) in seconds.
         */
        public var rtoInSecs: kotlin.Int? = null
        /**
         * Status of the application.
         */
        public var status: aws.sdk.kotlin.services.resiliencehub.model.AppStatusType? = null
        /**
         * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.App) : this() {
            this.appArn = x.appArn
            this.assessmentSchedule = x.assessmentSchedule
            this.awsApplicationArn = x.awsApplicationArn
            this.complianceStatus = x.complianceStatus
            this.creationTime = x.creationTime
            this.description = x.description
            this.driftStatus = x.driftStatus
            this.eventSubscriptions = x.eventSubscriptions
            this.lastAppComplianceEvaluationTime = x.lastAppComplianceEvaluationTime
            this.lastDriftEvaluationTime = x.lastDriftEvaluationTime
            this.lastResiliencyScoreEvaluationTime = x.lastResiliencyScoreEvaluationTime
            this.name = x.name
            this.permissionModel = x.permissionModel
            this.policyArn = x.policyArn
            this.resiliencyScore = x.resiliencyScore
            this.rpoInSecs = x.rpoInSecs
            this.rtoInSecs = x.rtoInSecs
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.App = App(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.PermissionModel] inside the given [block]
         */
        public fun permissionModel(block: aws.sdk.kotlin.services.resiliencehub.model.PermissionModel.Builder.() -> kotlin.Unit) {
            this.permissionModel = aws.sdk.kotlin.services.resiliencehub.model.PermissionModel.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            return this
        }
    }
}
