// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a recommendation for a CloudWatch alarm.
 */
public class AlarmRecommendation private constructor(builder: Builder) {
    /**
     * Application Component name for the CloudWatch alarm recommendation. This name is saved as the first item in the `appComponentNames` list.
     */
    @Deprecated("An alarm recommendation can be attached to multiple Application Components, hence this property will be replaced by the new property 'appComponentNames'.")
    public val appComponentName: kotlin.String? = builder.appComponentName
    /**
     * List of Application Component names for the CloudWatch alarm recommendation.
     */
    public val appComponentNames: List<String>? = builder.appComponentNames
    /**
     * Description of the alarm recommendation.
     */
    public val description: kotlin.String? = builder.description
    /**
     * List of CloudWatch alarm recommendations.
     */
    public val items: List<RecommendationItem>? = builder.items
    /**
     * Name of the alarm recommendation.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The prerequisite for the alarm recommendation.
     */
    public val prerequisite: kotlin.String? = builder.prerequisite
    /**
     * Identifier of the alarm recommendation.
     */
    public val recommendationId: kotlin.String = requireNotNull(builder.recommendationId) { "A non-null value must be provided for recommendationId" }
    /**
     * Status of the recommended Amazon CloudWatch alarm.
     */
    public val recommendationStatus: aws.sdk.kotlin.services.resiliencehub.model.RecommendationStatus? = builder.recommendationStatus
    /**
     * Reference identifier of the alarm recommendation.
     */
    public val referenceId: kotlin.String = requireNotNull(builder.referenceId) { "A non-null value must be provided for referenceId" }
    /**
     * Type of alarm recommendation.
     */
    public val type: aws.sdk.kotlin.services.resiliencehub.model.AlarmType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.AlarmRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlarmRecommendation(")
        append("appComponentName=$appComponentName,")
        append("appComponentNames=$appComponentNames,")
        append("description=$description,")
        append("items=$items,")
        append("name=$name,")
        append("prerequisite=$prerequisite,")
        append("recommendationId=$recommendationId,")
        append("recommendationStatus=$recommendationStatus,")
        append("referenceId=$referenceId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appComponentName?.hashCode() ?: 0
        result = 31 * result + (appComponentNames?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (prerequisite?.hashCode() ?: 0)
        result = 31 * result + (recommendationId.hashCode())
        result = 31 * result + (recommendationStatus?.hashCode() ?: 0)
        result = 31 * result + (referenceId.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlarmRecommendation

        if (appComponentName != other.appComponentName) return false
        if (appComponentNames != other.appComponentNames) return false
        if (description != other.description) return false
        if (items != other.items) return false
        if (name != other.name) return false
        if (prerequisite != other.prerequisite) return false
        if (recommendationId != other.recommendationId) return false
        if (recommendationStatus != other.recommendationStatus) return false
        if (referenceId != other.referenceId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.AlarmRecommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Application Component name for the CloudWatch alarm recommendation. This name is saved as the first item in the `appComponentNames` list.
         */
        @Deprecated("An alarm recommendation can be attached to multiple Application Components, hence this property will be replaced by the new property 'appComponentNames'.")
        public var appComponentName: kotlin.String? = null
        /**
         * List of Application Component names for the CloudWatch alarm recommendation.
         */
        public var appComponentNames: List<String>? = null
        /**
         * Description of the alarm recommendation.
         */
        public var description: kotlin.String? = null
        /**
         * List of CloudWatch alarm recommendations.
         */
        public var items: List<RecommendationItem>? = null
        /**
         * Name of the alarm recommendation.
         */
        public var name: kotlin.String? = null
        /**
         * The prerequisite for the alarm recommendation.
         */
        public var prerequisite: kotlin.String? = null
        /**
         * Identifier of the alarm recommendation.
         */
        public var recommendationId: kotlin.String? = null
        /**
         * Status of the recommended Amazon CloudWatch alarm.
         */
        public var recommendationStatus: aws.sdk.kotlin.services.resiliencehub.model.RecommendationStatus? = null
        /**
         * Reference identifier of the alarm recommendation.
         */
        public var referenceId: kotlin.String? = null
        /**
         * Type of alarm recommendation.
         */
        public var type: aws.sdk.kotlin.services.resiliencehub.model.AlarmType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.AlarmRecommendation) : this() {
            this.appComponentName = x.appComponentName
            this.appComponentNames = x.appComponentNames
            this.description = x.description
            this.items = x.items
            this.name = x.name
            this.prerequisite = x.prerequisite
            this.recommendationId = x.recommendationId
            this.recommendationStatus = x.recommendationStatus
            this.referenceId = x.referenceId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.AlarmRecommendation = AlarmRecommendation(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (recommendationId == null) recommendationId = ""
            if (referenceId == null) referenceId = ""
            if (type == null) type = AlarmType.SdkUnknown("no value provided")
            return this
        }
    }
}
