// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.resiliencehub.model.ListUnsupportedAppVersionResourcesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ResiliencehubException
import aws.sdk.kotlin.services.resiliencehub.model.UnsupportedResource
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListUnsupportedAppVersionResourcesOperationDeserializer: HttpDeserialize<ListUnsupportedAppVersionResourcesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListUnsupportedAppVersionResourcesResponse {
        if (!response.status.isSuccess()) {
            throwListUnsupportedAppVersionResourcesError(context, response)
        }
        val builder = ListUnsupportedAppVersionResourcesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListUnsupportedAppVersionResourcesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListUnsupportedAppVersionResourcesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ResiliencehubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ResiliencehubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListUnsupportedAppVersionResourcesOperationBody(builder: ListUnsupportedAppVersionResourcesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val RESOLUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resolutionId"))
    val UNSUPPORTEDRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("unsupportedResources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESOLUTIONID_DESCRIPTOR)
        field(UNSUPPORTEDRESOURCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                RESOLUTIONID_DESCRIPTOR.index -> builder.resolutionId = deserializeString()
                UNSUPPORTEDRESOURCES_DESCRIPTOR.index -> builder.unsupportedResources =
                    deserializer.deserializeList(UNSUPPORTEDRESOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<UnsupportedResource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnsupportedResourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
