// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionResourcesResponse
import aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource
import aws.sdk.kotlin.services.resiliencehub.model.ResiliencehubException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListAppVersionResourcesOperationDeserializer: HttpDeserialize<ListAppVersionResourcesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListAppVersionResourcesResponse {
        if (!response.status.isSuccess()) {
            throwListAppVersionResourcesError(context, response)
        }
        val builder = ListAppVersionResourcesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAppVersionResourcesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListAppVersionResourcesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ResiliencehubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ResiliencehubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAppVersionResourcesOperationBody(builder: ListAppVersionResourcesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val PHYSICALRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("physicalResources"))
    val RESOLUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resolutionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(PHYSICALRESOURCES_DESCRIPTOR)
        field(RESOLUTIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PHYSICALRESOURCES_DESCRIPTOR.index -> builder.physicalResources =
                    deserializer.deserializeList(PHYSICALRESOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<PhysicalResource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePhysicalResourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOLUTIONID_DESCRIPTOR.index -> builder.resolutionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
