// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model



public class UpdateResiliencyPolicyRequest private constructor(builder: Builder) {
    /**
     * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
     */
    public val dataLocationConstraint: aws.sdk.kotlin.services.resiliencehub.model.DataLocationConstraint? = builder.dataLocationConstraint
    /**
     * The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.
     */
    public val policy: Map<String, FailurePolicy>? = builder.policy
    /**
     * The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val policyArn: kotlin.String? = builder.policyArn
    /**
     * The description for the policy.
     */
    public val policyDescription: kotlin.String? = builder.policyDescription
    /**
     * The name of the policy
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * The tier for this resiliency policy, ranging from the highest severity (`MissionCritical`) to lowest (`NonCritical`).
     */
    public val tier: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicyTier? = builder.tier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.UpdateResiliencyPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateResiliencyPolicyRequest(")
        append("dataLocationConstraint=$dataLocationConstraint,")
        append("policy=$policy,")
        append("policyArn=$policyArn,")
        append("policyDescription=$policyDescription,")
        append("policyName=$policyName,")
        append("tier=$tier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataLocationConstraint?.hashCode() ?: 0
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (policyArn?.hashCode() ?: 0)
        result = 31 * result + (policyDescription?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateResiliencyPolicyRequest

        if (dataLocationConstraint != other.dataLocationConstraint) return false
        if (policy != other.policy) return false
        if (policyArn != other.policyArn) return false
        if (policyDescription != other.policyDescription) return false
        if (policyName != other.policyName) return false
        if (tier != other.tier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.UpdateResiliencyPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
         */
        public var dataLocationConstraint: aws.sdk.kotlin.services.resiliencehub.model.DataLocationConstraint? = null
        /**
         * The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.
         */
        public var policy: Map<String, FailurePolicy>? = null
        /**
         * The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var policyArn: kotlin.String? = null
        /**
         * The description for the policy.
         */
        public var policyDescription: kotlin.String? = null
        /**
         * The name of the policy
         */
        public var policyName: kotlin.String? = null
        /**
         * The tier for this resiliency policy, ranging from the highest severity (`MissionCritical`) to lowest (`NonCritical`).
         */
        public var tier: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicyTier? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.UpdateResiliencyPolicyRequest) : this() {
            this.dataLocationConstraint = x.dataLocationConstraint
            this.policy = x.policy
            this.policyArn = x.policyArn
            this.policyDescription = x.policyDescription
            this.policyName = x.policyName
            this.tier = x.tier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.UpdateResiliencyPolicyRequest = UpdateResiliencyPolicyRequest(this)
    }
}
