// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model



/**
 * Defines a resource mapping.
 */
public class ResourceMapping private constructor(builder: Builder) {
    /**
     * The name of the application this resource is mapped to.
     */
    public val appRegistryAppName: kotlin.String? = builder.appRegistryAppName
    /**
     * The name of the CloudFormation stack this resource is mapped to.
     */
    public val logicalStackName: kotlin.String? = builder.logicalStackName
    /**
     * Specifies the type of resource mapping.
     *
     * ## AppRegistryApp
     * The resource is mapped to another application. The name of the application is contained in the `appRegistryAppName` property.
     *
     * ## CfnStack
     * The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the `logicalStackName` property.
     *
     * ## Resource
     * The resource is mapped to another resource. The name of the resource is contained in the `resourceName` property.
     *
     * ## ResourceGroup
     * The resource is mapped to a resource group. The name of the resource group is contained in the `resourceGroupName` property.
     */
    public val mappingType: aws.sdk.kotlin.services.resiliencehub.model.ResourceMappingType? = builder.mappingType
    /**
     * The identifier of this resource.
     */
    public val physicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId? = builder.physicalResourceId
    /**
     * The name of the resource group this resource is mapped to.
     */
    public val resourceGroupName: kotlin.String? = builder.resourceGroupName
    /**
     * The name of the resource this resource is mapped to.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * The short name of the Terraform source.
     */
    public val terraformSourceName: kotlin.String? = builder.terraformSourceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.ResourceMapping = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceMapping(")
        append("appRegistryAppName=$appRegistryAppName,")
        append("logicalStackName=$logicalStackName,")
        append("mappingType=$mappingType,")
        append("physicalResourceId=$physicalResourceId,")
        append("resourceGroupName=$resourceGroupName,")
        append("resourceName=$resourceName,")
        append("terraformSourceName=$terraformSourceName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appRegistryAppName?.hashCode() ?: 0
        result = 31 * result + (logicalStackName?.hashCode() ?: 0)
        result = 31 * result + (mappingType?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (terraformSourceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceMapping

        if (appRegistryAppName != other.appRegistryAppName) return false
        if (logicalStackName != other.logicalStackName) return false
        if (mappingType != other.mappingType) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (resourceGroupName != other.resourceGroupName) return false
        if (resourceName != other.resourceName) return false
        if (terraformSourceName != other.terraformSourceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.ResourceMapping = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the application this resource is mapped to.
         */
        public var appRegistryAppName: kotlin.String? = null
        /**
         * The name of the CloudFormation stack this resource is mapped to.
         */
        public var logicalStackName: kotlin.String? = null
        /**
         * Specifies the type of resource mapping.
         *
         * ## AppRegistryApp
         * The resource is mapped to another application. The name of the application is contained in the `appRegistryAppName` property.
         *
         * ## CfnStack
         * The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the `logicalStackName` property.
         *
         * ## Resource
         * The resource is mapped to another resource. The name of the resource is contained in the `resourceName` property.
         *
         * ## ResourceGroup
         * The resource is mapped to a resource group. The name of the resource group is contained in the `resourceGroupName` property.
         */
        public var mappingType: aws.sdk.kotlin.services.resiliencehub.model.ResourceMappingType? = null
        /**
         * The identifier of this resource.
         */
        public var physicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId? = null
        /**
         * The name of the resource group this resource is mapped to.
         */
        public var resourceGroupName: kotlin.String? = null
        /**
         * The name of the resource this resource is mapped to.
         */
        public var resourceName: kotlin.String? = null
        /**
         * The short name of the Terraform source.
         */
        public var terraformSourceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.ResourceMapping) : this() {
            this.appRegistryAppName = x.appRegistryAppName
            this.logicalStackName = x.logicalStackName
            this.mappingType = x.mappingType
            this.physicalResourceId = x.physicalResourceId
            this.resourceGroupName = x.resourceGroupName
            this.resourceName = x.resourceName
            this.terraformSourceName = x.terraformSourceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.ResourceMapping = ResourceMapping(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId] inside the given [block]
         */
        public fun physicalResourceId(block: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId.Builder.() -> kotlin.Unit) {
            this.physicalResourceId = aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId.invoke(block)
        }
    }
}
