// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Defines a recommendation template created with the CreateRecommendationTemplate action.
 */
public class RecommendationTemplate private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val appArn: kotlin.String? = builder.appArn
    /**
     * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val assessmentArn: kotlin.String? = builder.assessmentArn
    /**
     * The end time for the action.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The format of the recommendation template.
     *
     * ## CfnJson
     * The template is CloudFormation JSON.
     *
     * ## CfnYaml
     * The template is CloudFormation YAML.
     */
    public val format: aws.sdk.kotlin.services.resiliencehub.model.TemplateFormat? = builder.format
    /**
     * The message for the recommendation template.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The name for the recommendation template.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates if replacements are needed.
     */
    public val needsReplacements: kotlin.Boolean? = builder.needsReplacements
    /**
     * Identifiers for the recommendations used in the recommendation template.
     */
    public val recommendationIds: List<String>? = builder.recommendationIds
    /**
     * The Amazon Resource Name (ARN) for the recommendation template.
     */
    public val recommendationTemplateArn: kotlin.String? = builder.recommendationTemplateArn
    /**
     * An array of strings that specify the recommendation template type or types.
     *
     * ## Alarm
     * The template is an AlarmRecommendation template.
     *
     * ## Sop
     * The template is a SopRecommendation template.
     *
     * ## Test
     * The template is a TestRecommendation template.
     */
    public val recommendationTypes: List<RenderRecommendationType>? = builder.recommendationTypes
    /**
     * The start time for the action.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the action.
     */
    public val status: aws.sdk.kotlin.services.resiliencehub.model.RecommendationTemplateStatus? = builder.status
    /**
     * The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The file location of the template.
     */
    public val templatesLocation: aws.sdk.kotlin.services.resiliencehub.model.S3Location? = builder.templatesLocation

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.RecommendationTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendationTemplate(")
        append("appArn=$appArn,")
        append("assessmentArn=$assessmentArn,")
        append("endTime=$endTime,")
        append("format=$format,")
        append("message=$message,")
        append("name=$name,")
        append("needsReplacements=$needsReplacements,")
        append("recommendationIds=$recommendationIds,")
        append("recommendationTemplateArn=$recommendationTemplateArn,")
        append("recommendationTypes=$recommendationTypes,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("tags=*** Sensitive Data Redacted ***,")
        append("templatesLocation=$templatesLocation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn?.hashCode() ?: 0
        result = 31 * result + (assessmentArn?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (needsReplacements?.hashCode() ?: 0)
        result = 31 * result + (recommendationIds?.hashCode() ?: 0)
        result = 31 * result + (recommendationTemplateArn?.hashCode() ?: 0)
        result = 31 * result + (recommendationTypes?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templatesLocation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendationTemplate

        if (appArn != other.appArn) return false
        if (assessmentArn != other.assessmentArn) return false
        if (endTime != other.endTime) return false
        if (format != other.format) return false
        if (message != other.message) return false
        if (name != other.name) return false
        if (needsReplacements != other.needsReplacements) return false
        if (recommendationIds != other.recommendationIds) return false
        if (recommendationTemplateArn != other.recommendationTemplateArn) return false
        if (recommendationTypes != other.recommendationTypes) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (templatesLocation != other.templatesLocation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.RecommendationTemplate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var appArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var assessmentArn: kotlin.String? = null
        /**
         * The end time for the action.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The format of the recommendation template.
         *
         * ## CfnJson
         * The template is CloudFormation JSON.
         *
         * ## CfnYaml
         * The template is CloudFormation YAML.
         */
        public var format: aws.sdk.kotlin.services.resiliencehub.model.TemplateFormat? = null
        /**
         * The message for the recommendation template.
         */
        public var message: kotlin.String? = null
        /**
         * The name for the recommendation template.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates if replacements are needed.
         */
        public var needsReplacements: kotlin.Boolean? = null
        /**
         * Identifiers for the recommendations used in the recommendation template.
         */
        public var recommendationIds: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) for the recommendation template.
         */
        public var recommendationTemplateArn: kotlin.String? = null
        /**
         * An array of strings that specify the recommendation template type or types.
         *
         * ## Alarm
         * The template is an AlarmRecommendation template.
         *
         * ## Sop
         * The template is a SopRecommendation template.
         *
         * ## Test
         * The template is a TestRecommendation template.
         */
        public var recommendationTypes: List<RenderRecommendationType>? = null
        /**
         * The start time for the action.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the action.
         */
        public var status: aws.sdk.kotlin.services.resiliencehub.model.RecommendationTemplateStatus? = null
        /**
         * The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
         */
        public var tags: Map<String, String>? = null
        /**
         * The file location of the template.
         */
        public var templatesLocation: aws.sdk.kotlin.services.resiliencehub.model.S3Location? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.RecommendationTemplate) : this() {
            this.appArn = x.appArn
            this.assessmentArn = x.assessmentArn
            this.endTime = x.endTime
            this.format = x.format
            this.message = x.message
            this.name = x.name
            this.needsReplacements = x.needsReplacements
            this.recommendationIds = x.recommendationIds
            this.recommendationTemplateArn = x.recommendationTemplateArn
            this.recommendationTypes = x.recommendationTypes
            this.startTime = x.startTime
            this.status = x.status
            this.tags = x.tags
            this.templatesLocation = x.templatesLocation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.RecommendationTemplate = RecommendationTemplate(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.S3Location] inside the given [block]
         */
        public fun templatesLocation(block: aws.sdk.kotlin.services.resiliencehub.model.S3Location.Builder.() -> kotlin.Unit) {
            this.templatesLocation = aws.sdk.kotlin.services.resiliencehub.model.S3Location.invoke(block)
        }
    }
}
