// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model



/**
 * Defines a physical resource identifier.
 */
public class PhysicalResourceId private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account that owns the physical resource.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The Amazon Web Services Region that the physical resource is located in.
     */
    public val awsRegion: kotlin.String? = builder.awsRegion
    /**
     * The identifier of the physical resource.
     */
    public val identifier: kotlin.String? = builder.identifier
    /**
     * Specifies the type of physical resource identifier.
     *
     * ## Arn
     * The resource identifier is an Amazon Resource Name (ARN) .
     *
     * ## Native
     * The resource identifier is a Resilience Hub-native identifier.
     */
    public val type: aws.sdk.kotlin.services.resiliencehub.model.PhysicalIdentifierType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PhysicalResourceId(")
        append("awsAccountId=$awsAccountId,")
        append("awsRegion=$awsRegion,")
        append("identifier=$identifier,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (awsRegion?.hashCode() ?: 0)
        result = 31 * result + (identifier?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PhysicalResourceId

        if (awsAccountId != other.awsAccountId) return false
        if (awsRegion != other.awsRegion) return false
        if (identifier != other.identifier) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account that owns the physical resource.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The Amazon Web Services Region that the physical resource is located in.
         */
        public var awsRegion: kotlin.String? = null
        /**
         * The identifier of the physical resource.
         */
        public var identifier: kotlin.String? = null
        /**
         * Specifies the type of physical resource identifier.
         *
         * ## Arn
         * The resource identifier is an Amazon Resource Name (ARN) .
         *
         * ## Native
         * The resource identifier is a Resilience Hub-native identifier.
         */
        public var type: aws.sdk.kotlin.services.resiliencehub.model.PhysicalIdentifierType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId) : this() {
            this.awsAccountId = x.awsAccountId
            this.awsRegion = x.awsRegion
            this.identifier = x.identifier
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId = PhysicalResourceId(this)
    }
}
