// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model



/**
 * Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier.
 */
public class PhysicalResource private constructor(builder: Builder) {
    /**
     * The application components that belong to this resource.
     */
    public val appComponents: List<AppComponent>? = builder.appComponents
    /**
     * The logical identifier of the resource.
     */
    public val logicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId? = builder.logicalResourceId
    /**
     * The physical identifier of the resource.
     */
    public val physicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId? = builder.physicalResourceId
    /**
     * The name of the resource.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * The type of resource.
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PhysicalResource(")
        append("appComponents=$appComponents,")
        append("logicalResourceId=$logicalResourceId,")
        append("physicalResourceId=$physicalResourceId,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appComponents?.hashCode() ?: 0
        result = 31 * result + (logicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PhysicalResource

        if (appComponents != other.appComponents) return false
        if (logicalResourceId != other.logicalResourceId) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The application components that belong to this resource.
         */
        public var appComponents: List<AppComponent>? = null
        /**
         * The logical identifier of the resource.
         */
        public var logicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId? = null
        /**
         * The physical identifier of the resource.
         */
        public var physicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId? = null
        /**
         * The name of the resource.
         */
        public var resourceName: kotlin.String? = null
        /**
         * The type of resource.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource) : this() {
            this.appComponents = x.appComponents
            this.logicalResourceId = x.logicalResourceId
            this.physicalResourceId = x.physicalResourceId
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource = PhysicalResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId] inside the given [block]
         */
        public fun logicalResourceId(block: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId.Builder.() -> kotlin.Unit) {
            this.logicalResourceId = aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId] inside the given [block]
         */
        public fun physicalResourceId(block: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId.Builder.() -> kotlin.Unit) {
            this.physicalResourceId = aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId.invoke(block)
        }
    }
}
