// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model



/**
 * Defines the compliance against the resiliency policy for a disruption.
 */
public class DisruptionCompliance private constructor(builder: Builder) {
    /**
     * The Recovery Point Objective (RPO) that is achievable, in seconds.
     */
    public val achievableRpoInSecs: kotlin.Int = builder.achievableRpoInSecs
    /**
     * The Recovery Time Objective (RTO) that is achievable, in seconds
     */
    public val achievableRtoInSecs: kotlin.Int = builder.achievableRtoInSecs
    /**
     * The current status of compliance for the resiliency policy.
     */
    public val complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.ComplianceStatus? = builder.complianceStatus
    /**
     * The current RPO, in seconds.
     */
    public val currentRpoInSecs: kotlin.Int = builder.currentRpoInSecs
    /**
     * The current RTO, in seconds.
     */
    public val currentRtoInSecs: kotlin.Int = builder.currentRtoInSecs
    /**
     * The disruption compliance message.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The RPO description.
     */
    public val rpoDescription: kotlin.String? = builder.rpoDescription
    /**
     * The RPO reference identifier.
     */
    public val rpoReferenceId: kotlin.String? = builder.rpoReferenceId
    /**
     * The RTO description.
     */
    public val rtoDescription: kotlin.String? = builder.rtoDescription
    /**
     * The RTO reference identifier.
     */
    public val rtoReferenceId: kotlin.String? = builder.rtoReferenceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.DisruptionCompliance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DisruptionCompliance(")
        append("achievableRpoInSecs=$achievableRpoInSecs,")
        append("achievableRtoInSecs=$achievableRtoInSecs,")
        append("complianceStatus=$complianceStatus,")
        append("currentRpoInSecs=$currentRpoInSecs,")
        append("currentRtoInSecs=$currentRtoInSecs,")
        append("message=$message,")
        append("rpoDescription=$rpoDescription,")
        append("rpoReferenceId=$rpoReferenceId,")
        append("rtoDescription=$rtoDescription,")
        append("rtoReferenceId=$rtoReferenceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = achievableRpoInSecs
        result = 31 * result + (achievableRtoInSecs)
        result = 31 * result + (complianceStatus?.hashCode() ?: 0)
        result = 31 * result + (currentRpoInSecs)
        result = 31 * result + (currentRtoInSecs)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (rpoDescription?.hashCode() ?: 0)
        result = 31 * result + (rpoReferenceId?.hashCode() ?: 0)
        result = 31 * result + (rtoDescription?.hashCode() ?: 0)
        result = 31 * result + (rtoReferenceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DisruptionCompliance

        if (achievableRpoInSecs != other.achievableRpoInSecs) return false
        if (achievableRtoInSecs != other.achievableRtoInSecs) return false
        if (complianceStatus != other.complianceStatus) return false
        if (currentRpoInSecs != other.currentRpoInSecs) return false
        if (currentRtoInSecs != other.currentRtoInSecs) return false
        if (message != other.message) return false
        if (rpoDescription != other.rpoDescription) return false
        if (rpoReferenceId != other.rpoReferenceId) return false
        if (rtoDescription != other.rtoDescription) return false
        if (rtoReferenceId != other.rtoReferenceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.DisruptionCompliance = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Recovery Point Objective (RPO) that is achievable, in seconds.
         */
        public var achievableRpoInSecs: kotlin.Int = 0
        /**
         * The Recovery Time Objective (RTO) that is achievable, in seconds
         */
        public var achievableRtoInSecs: kotlin.Int = 0
        /**
         * The current status of compliance for the resiliency policy.
         */
        public var complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.ComplianceStatus? = null
        /**
         * The current RPO, in seconds.
         */
        public var currentRpoInSecs: kotlin.Int = 0
        /**
         * The current RTO, in seconds.
         */
        public var currentRtoInSecs: kotlin.Int = 0
        /**
         * The disruption compliance message.
         */
        public var message: kotlin.String? = null
        /**
         * The RPO description.
         */
        public var rpoDescription: kotlin.String? = null
        /**
         * The RPO reference identifier.
         */
        public var rpoReferenceId: kotlin.String? = null
        /**
         * The RTO description.
         */
        public var rtoDescription: kotlin.String? = null
        /**
         * The RTO reference identifier.
         */
        public var rtoReferenceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.DisruptionCompliance) : this() {
            this.achievableRpoInSecs = x.achievableRpoInSecs
            this.achievableRtoInSecs = x.achievableRtoInSecs
            this.complianceStatus = x.complianceStatus
            this.currentRpoInSecs = x.currentRpoInSecs
            this.currentRtoInSecs = x.currentRtoInSecs
            this.message = x.message
            this.rpoDescription = x.rpoDescription
            this.rpoReferenceId = x.rpoReferenceId
            this.rtoDescription = x.rtoDescription
            this.rtoReferenceId = x.rtoReferenceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.DisruptionCompliance = DisruptionCompliance(this)
    }
}
