// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model



public class CreateResiliencyPolicyRequest private constructor(builder: Builder) {
    /**
     * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
     */
    public val dataLocationConstraint: aws.sdk.kotlin.services.resiliencehub.model.DataLocationConstraint? = builder.dataLocationConstraint
    /**
     * The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.
     */
    public val policy: Map<String, FailurePolicy>? = builder.policy
    /**
     * The description for the policy.
     */
    public val policyDescription: kotlin.String? = builder.policyDescription
    /**
     * The name of the policy
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The tier for this resiliency policy, ranging from the highest severity (`MissionCritical`) to lowest (`NonCritical`).
     */
    public val tier: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicyTier? = builder.tier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.CreateResiliencyPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateResiliencyPolicyRequest(")
        append("clientToken=$clientToken,")
        append("dataLocationConstraint=$dataLocationConstraint,")
        append("policy=$policy,")
        append("policyDescription=$policyDescription,")
        append("policyName=$policyName,")
        append("tags=*** Sensitive Data Redacted ***,")
        append("tier=$tier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (dataLocationConstraint?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (policyDescription?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateResiliencyPolicyRequest

        if (clientToken != other.clientToken) return false
        if (dataLocationConstraint != other.dataLocationConstraint) return false
        if (policy != other.policy) return false
        if (policyDescription != other.policyDescription) return false
        if (policyName != other.policyName) return false
        if (tags != other.tags) return false
        if (tier != other.tier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.CreateResiliencyPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
         */
        public var dataLocationConstraint: aws.sdk.kotlin.services.resiliencehub.model.DataLocationConstraint? = null
        /**
         * The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.
         */
        public var policy: Map<String, FailurePolicy>? = null
        /**
         * The description for the policy.
         */
        public var policyDescription: kotlin.String? = null
        /**
         * The name of the policy
         */
        public var policyName: kotlin.String? = null
        /**
         * The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
         */
        public var tags: Map<String, String>? = null
        /**
         * The tier for this resiliency policy, ranging from the highest severity (`MissionCritical`) to lowest (`NonCritical`).
         */
        public var tier: aws.sdk.kotlin.services.resiliencehub.model.ResiliencyPolicyTier? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.CreateResiliencyPolicyRequest) : this() {
            this.clientToken = x.clientToken
            this.dataLocationConstraint = x.dataLocationConstraint
            this.policy = x.policy
            this.policyDescription = x.policyDescription
            this.policyName = x.policyName
            this.tags = x.tags
            this.tier = x.tier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.CreateResiliencyPolicyRequest = CreateResiliencyPolicyRequest(this)
    }
}
