// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Defines an application assessment summary.
 */
public class AppAssessmentSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val appArn: kotlin.String? = builder.appArn
    /**
     * The version of the application.
     */
    public val appVersion: kotlin.String? = builder.appVersion
    /**
     * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val assessmentArn: kotlin.String? = builder.assessmentArn
    /**
     * The name of the assessment.
     */
    public val assessmentName: kotlin.String? = builder.assessmentName
    /**
     * The current status of the assessment for the resiliency policy.
     */
    public val assessmentStatus: aws.sdk.kotlin.services.resiliencehub.model.AssessmentStatus? = builder.assessmentStatus
    /**
     * The current status of compliance for the resiliency policy.
     */
    public val complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.ComplianceStatus? = builder.complianceStatus
    /**
     * The cost for the application.
     */
    public val cost: aws.sdk.kotlin.services.resiliencehub.model.Cost? = builder.cost
    /**
     * The end time for the action.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The entity that invoked the assessment.
     */
    public val invoker: aws.sdk.kotlin.services.resiliencehub.model.AssessmentInvoker? = builder.invoker
    /**
     * The message from the assessment run.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The current resiliency score for the application.
     */
    public val resiliencyScore: kotlin.Double = builder.resiliencyScore
    /**
     * The starting time for the action.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppAssessmentSummary(")
        append("appArn=$appArn,")
        append("appVersion=$appVersion,")
        append("assessmentArn=$assessmentArn,")
        append("assessmentName=$assessmentName,")
        append("assessmentStatus=$assessmentStatus,")
        append("complianceStatus=$complianceStatus,")
        append("cost=$cost,")
        append("endTime=$endTime,")
        append("invoker=$invoker,")
        append("message=$message,")
        append("resiliencyScore=$resiliencyScore,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn?.hashCode() ?: 0
        result = 31 * result + (appVersion?.hashCode() ?: 0)
        result = 31 * result + (assessmentArn?.hashCode() ?: 0)
        result = 31 * result + (assessmentName?.hashCode() ?: 0)
        result = 31 * result + (assessmentStatus?.hashCode() ?: 0)
        result = 31 * result + (complianceStatus?.hashCode() ?: 0)
        result = 31 * result + (cost?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (invoker?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (resiliencyScore.hashCode())
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppAssessmentSummary

        if (appArn != other.appArn) return false
        if (appVersion != other.appVersion) return false
        if (assessmentArn != other.assessmentArn) return false
        if (assessmentName != other.assessmentName) return false
        if (assessmentStatus != other.assessmentStatus) return false
        if (complianceStatus != other.complianceStatus) return false
        if (cost != other.cost) return false
        if (endTime != other.endTime) return false
        if (invoker != other.invoker) return false
        if (message != other.message) return false
        if (resiliencyScore != other.resiliencyScore) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var appArn: kotlin.String? = null
        /**
         * The version of the application.
         */
        public var appVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var assessmentArn: kotlin.String? = null
        /**
         * The name of the assessment.
         */
        public var assessmentName: kotlin.String? = null
        /**
         * The current status of the assessment for the resiliency policy.
         */
        public var assessmentStatus: aws.sdk.kotlin.services.resiliencehub.model.AssessmentStatus? = null
        /**
         * The current status of compliance for the resiliency policy.
         */
        public var complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.ComplianceStatus? = null
        /**
         * The cost for the application.
         */
        public var cost: aws.sdk.kotlin.services.resiliencehub.model.Cost? = null
        /**
         * The end time for the action.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The entity that invoked the assessment.
         */
        public var invoker: aws.sdk.kotlin.services.resiliencehub.model.AssessmentInvoker? = null
        /**
         * The message from the assessment run.
         */
        public var message: kotlin.String? = null
        /**
         * The current resiliency score for the application.
         */
        public var resiliencyScore: kotlin.Double = 0.0
        /**
         * The starting time for the action.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentSummary) : this() {
            this.appArn = x.appArn
            this.appVersion = x.appVersion
            this.assessmentArn = x.assessmentArn
            this.assessmentName = x.assessmentName
            this.assessmentStatus = x.assessmentStatus
            this.complianceStatus = x.complianceStatus
            this.cost = x.cost
            this.endTime = x.endTime
            this.invoker = x.invoker
            this.message = x.message
            this.resiliencyScore = x.resiliencyScore
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentSummary = AppAssessmentSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.Cost] inside the given [block]
         */
        public fun cost(block: aws.sdk.kotlin.services.resiliencehub.model.Cost.Builder.() -> kotlin.Unit) {
            this.cost = aws.sdk.kotlin.services.resiliencehub.model.Cost.invoke(block)
        }
    }
}
