// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.resiliencehub.model.*
import aws.sdk.kotlin.services.resiliencehub.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "resiliencehub"
public const val ServiceApiVersion: String = "2020-04-30"
public const val SdkVersion: String = "0.17.12-beta"

internal class DefaultResiliencehubClient(override val config: ResiliencehubClient.Config) : ResiliencehubClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds the resource mapping for the draft application version.
     */
    override suspend fun addDraftAppVersionResourceMappings(input: AddDraftAppVersionResourceMappingsRequest): AddDraftAppVersionResourceMappingsResponse {
        val op = SdkHttpOperation.build<AddDraftAppVersionResourceMappingsRequest, AddDraftAppVersionResourceMappingsResponse> {
            serializer = AddDraftAppVersionResourceMappingsOperationSerializer()
            deserializer = AddDraftAppVersionResourceMappingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddDraftAppVersionResourceMappings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Resilience Hub application. A Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more–up to five–CloudFormation stacks, and an appropriate resiliency policy.
     *
     * After you create a Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).
     */
    override suspend fun createApp(input: CreateAppRequest): CreateAppResponse {
        val op = SdkHttpOperation.build<CreateAppRequest, CreateAppResponse> {
            serializer = CreateAppOperationSerializer()
            deserializer = CreateAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new recommendation template.
     */
    override suspend fun createRecommendationTemplate(input: CreateRecommendationTemplateRequest): CreateRecommendationTemplateResponse {
        val op = SdkHttpOperation.build<CreateRecommendationTemplateRequest, CreateRecommendationTemplateResponse> {
            serializer = CreateRecommendationTemplateOperationSerializer()
            deserializer = CreateRecommendationTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRecommendationTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a resiliency policy for an application.
     */
    override suspend fun createResiliencyPolicy(input: CreateResiliencyPolicyRequest): CreateResiliencyPolicyResponse {
        val op = SdkHttpOperation.build<CreateResiliencyPolicyRequest, CreateResiliencyPolicyResponse> {
            serializer = CreateResiliencyPolicyOperationSerializer()
            deserializer = CreateResiliencyPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateResiliencyPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an AWS Resilience Hub application. This is a destructive action that can't be undone.
     */
    override suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse {
        val op = SdkHttpOperation.build<DeleteAppRequest, DeleteAppResponse> {
            serializer = DeleteAppOperationSerializer()
            deserializer = DeleteAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an AWS Resilience Hub application assessment. This is a destructive action that can't be undone.
     */
    override suspend fun deleteAppAssessment(input: DeleteAppAssessmentRequest): DeleteAppAssessmentResponse {
        val op = SdkHttpOperation.build<DeleteAppAssessmentRequest, DeleteAppAssessmentResponse> {
            serializer = DeleteAppAssessmentOperationSerializer()
            deserializer = DeleteAppAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAppAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a recommendation template. This is a destructive action that can't be undone.
     */
    override suspend fun deleteRecommendationTemplate(input: DeleteRecommendationTemplateRequest): DeleteRecommendationTemplateResponse {
        val op = SdkHttpOperation.build<DeleteRecommendationTemplateRequest, DeleteRecommendationTemplateResponse> {
            serializer = DeleteRecommendationTemplateOperationSerializer()
            deserializer = DeleteRecommendationTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRecommendationTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a resiliency policy. This is a destructive action that can't be undone.
     */
    override suspend fun deleteResiliencyPolicy(input: DeleteResiliencyPolicyRequest): DeleteResiliencyPolicyResponse {
        val op = SdkHttpOperation.build<DeleteResiliencyPolicyRequest, DeleteResiliencyPolicyResponse> {
            serializer = DeleteResiliencyPolicyOperationSerializer()
            deserializer = DeleteResiliencyPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteResiliencyPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an AWS Resilience Hub application.
     */
    override suspend fun describeApp(input: DescribeAppRequest): DescribeAppResponse {
        val op = SdkHttpOperation.build<DescribeAppRequest, DescribeAppResponse> {
            serializer = DescribeAppOperationSerializer()
            deserializer = DescribeAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an assessment for an AWS Resilience Hub application.
     */
    override suspend fun describeAppAssessment(input: DescribeAppAssessmentRequest): DescribeAppAssessmentResponse {
        val op = SdkHttpOperation.build<DescribeAppAssessmentRequest, DescribeAppAssessmentResponse> {
            serializer = DescribeAppAssessmentOperationSerializer()
            deserializer = DescribeAppAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAppAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the resolution status for the specified resolution identifier for an application version. If `resolutionId` is not specified, the current resolution status is returned.
     */
    override suspend fun describeAppVersionResourcesResolutionStatus(input: DescribeAppVersionResourcesResolutionStatusRequest): DescribeAppVersionResourcesResolutionStatusResponse {
        val op = SdkHttpOperation.build<DescribeAppVersionResourcesResolutionStatusRequest, DescribeAppVersionResourcesResolutionStatusResponse> {
            serializer = DescribeAppVersionResourcesResolutionStatusOperationSerializer()
            deserializer = DescribeAppVersionResourcesResolutionStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAppVersionResourcesResolutionStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes details about an AWS Resilience Hub
     */
    override suspend fun describeAppVersionTemplate(input: DescribeAppVersionTemplateRequest): DescribeAppVersionTemplateResponse {
        val op = SdkHttpOperation.build<DescribeAppVersionTemplateRequest, DescribeAppVersionTemplateResponse> {
            serializer = DescribeAppVersionTemplateOperationSerializer()
            deserializer = DescribeAppVersionTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAppVersionTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the status of importing resources to an application version.
     */
    override suspend fun describeDraftAppVersionResourcesImportStatus(input: DescribeDraftAppVersionResourcesImportStatusRequest): DescribeDraftAppVersionResourcesImportStatusResponse {
        val op = SdkHttpOperation.build<DescribeDraftAppVersionResourcesImportStatusRequest, DescribeDraftAppVersionResourcesImportStatusResponse> {
            serializer = DescribeDraftAppVersionResourcesImportStatusOperationSerializer()
            deserializer = DescribeDraftAppVersionResourcesImportStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDraftAppVersionResourcesImportStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a specified resiliency policy for an AWS Resilience Hub application. The returned policy object includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.
     */
    override suspend fun describeResiliencyPolicy(input: DescribeResiliencyPolicyRequest): DescribeResiliencyPolicyResponse {
        val op = SdkHttpOperation.build<DescribeResiliencyPolicyRequest, DescribeResiliencyPolicyResponse> {
            serializer = DescribeResiliencyPolicyOperationSerializer()
            deserializer = DescribeResiliencyPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeResiliencyPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Imports resources from sources such as a CloudFormation stack, resource-groups, or application registry app to a draft application version.
     */
    override suspend fun importResourcesToDraftAppVersion(input: ImportResourcesToDraftAppVersionRequest): ImportResourcesToDraftAppVersionResponse {
        val op = SdkHttpOperation.build<ImportResourcesToDraftAppVersionRequest, ImportResourcesToDraftAppVersionResponse> {
            serializer = ImportResourcesToDraftAppVersionOperationSerializer()
            deserializer = ImportResourcesToDraftAppVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportResourcesToDraftAppVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the alarm recommendations for a AWS Resilience Hub application.
     */
    override suspend fun listAlarmRecommendations(input: ListAlarmRecommendationsRequest): ListAlarmRecommendationsResponse {
        val op = SdkHttpOperation.build<ListAlarmRecommendationsRequest, ListAlarmRecommendationsResponse> {
            serializer = ListAlarmRecommendationsOperationSerializer()
            deserializer = ListAlarmRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAlarmRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results for the response object.
     */
    override suspend fun listAppAssessments(input: ListAppAssessmentsRequest): ListAppAssessmentsResponse {
        val op = SdkHttpOperation.build<ListAppAssessmentsRequest, ListAppAssessmentsResponse> {
            serializer = ListAppAssessmentsOperationSerializer()
            deserializer = ListAppAssessmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppAssessments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the compliances for an AWS Resilience Hub component.
     */
    override suspend fun listAppComponentCompliances(input: ListAppComponentCompliancesRequest): ListAppComponentCompliancesResponse {
        val op = SdkHttpOperation.build<ListAppComponentCompliancesRequest, ListAppComponentCompliancesResponse> {
            serializer = ListAppComponentCompliancesOperationSerializer()
            deserializer = ListAppComponentCompliancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppComponentCompliances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the recommendations for an AWS Resilience Hub component.
     */
    override suspend fun listAppComponentRecommendations(input: ListAppComponentRecommendationsRequest): ListAppComponentRecommendationsResponse {
        val op = SdkHttpOperation.build<ListAppComponentRecommendationsRequest, ListAppComponentRecommendationsResponse> {
            serializer = ListAppComponentRecommendationsOperationSerializer()
            deserializer = ListAppComponentRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppComponentRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups, or an application registry app.
     */
    override suspend fun listAppVersionResourceMappings(input: ListAppVersionResourceMappingsRequest): ListAppVersionResourceMappingsResponse {
        val op = SdkHttpOperation.build<ListAppVersionResourceMappingsRequest, ListAppVersionResourceMappingsResponse> {
            serializer = ListAppVersionResourceMappingsOperationSerializer()
            deserializer = ListAppVersionResourceMappingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppVersionResourceMappings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the resources in an application version.
     */
    override suspend fun listAppVersionResources(input: ListAppVersionResourcesRequest): ListAppVersionResourcesResponse {
        val op = SdkHttpOperation.build<ListAppVersionResourcesRequest, ListAppVersionResourcesResponse> {
            serializer = ListAppVersionResourcesOperationSerializer()
            deserializer = ListAppVersionResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppVersionResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the different versions for the Resilience Hub applications.
     */
    override suspend fun listAppVersions(input: ListAppVersionsRequest): ListAppVersionsResponse {
        val op = SdkHttpOperation.build<ListAppVersionsRequest, ListAppVersionsResponse> {
            serializer = ListAppVersionsOperationSerializer()
            deserializer = ListAppVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists your Resilience Hub applications.
     */
    override suspend fun listApps(input: ListAppsRequest): ListAppsResponse {
        val op = SdkHttpOperation.build<ListAppsRequest, ListAppsResponse> {
            serializer = ListAppsOperationSerializer()
            deserializer = ListAppsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the recommendation templates for the Resilience Hub applications.
     */
    override suspend fun listRecommendationTemplates(input: ListRecommendationTemplatesRequest): ListRecommendationTemplatesResponse {
        val op = SdkHttpOperation.build<ListRecommendationTemplatesRequest, ListRecommendationTemplatesResponse> {
            serializer = ListRecommendationTemplatesOperationSerializer()
            deserializer = ListRecommendationTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRecommendationTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the resiliency policies for the Resilience Hub applications.
     */
    override suspend fun listResiliencyPolicies(input: ListResiliencyPoliciesRequest): ListResiliencyPoliciesResponse {
        val op = SdkHttpOperation.build<ListResiliencyPoliciesRequest, ListResiliencyPoliciesResponse> {
            serializer = ListResiliencyPoliciesOperationSerializer()
            deserializer = ListResiliencyPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListResiliencyPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
     */
    override suspend fun listSopRecommendations(input: ListSopRecommendationsRequest): ListSopRecommendationsResponse {
        val op = SdkHttpOperation.build<ListSopRecommendationsRequest, ListSopRecommendationsResponse> {
            serializer = ListSopRecommendationsOperationSerializer()
            deserializer = ListSopRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSopRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the suggested resiliency policies for the Resilience Hub applications.
     */
    override suspend fun listSuggestedResiliencyPolicies(input: ListSuggestedResiliencyPoliciesRequest): ListSuggestedResiliencyPoliciesResponse {
        val op = SdkHttpOperation.build<ListSuggestedResiliencyPoliciesRequest, ListSuggestedResiliencyPoliciesResponse> {
            serializer = ListSuggestedResiliencyPoliciesOperationSerializer()
            deserializer = ListSuggestedResiliencyPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSuggestedResiliencyPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for your resources in your Resilience Hub applications.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the test recommendations for the Resilience Hub application.
     */
    override suspend fun listTestRecommendations(input: ListTestRecommendationsRequest): ListTestRecommendationsResponse {
        val op = SdkHttpOperation.build<ListTestRecommendationsRequest, ListTestRecommendationsResponse> {
            serializer = ListTestRecommendationsOperationSerializer()
            deserializer = ListTestRecommendationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTestRecommendations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource that exists in the object that was used to create an app, but is not supported by Resilience Hub.
     */
    override suspend fun listUnsupportedAppVersionResources(input: ListUnsupportedAppVersionResourcesRequest): ListUnsupportedAppVersionResourcesResponse {
        val op = SdkHttpOperation.build<ListUnsupportedAppVersionResourcesRequest, ListUnsupportedAppVersionResourcesResponse> {
            serializer = ListUnsupportedAppVersionResourcesOperationSerializer()
            deserializer = ListUnsupportedAppVersionResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUnsupportedAppVersionResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Publishes a new version of a specific Resilience Hub application.
     */
    override suspend fun publishAppVersion(input: PublishAppVersionRequest): PublishAppVersionResponse {
        val op = SdkHttpOperation.build<PublishAppVersionRequest, PublishAppVersionResponse> {
            serializer = PublishAppVersionOperationSerializer()
            deserializer = PublishAppVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PublishAppVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds or updates the app template for a draft version of a Resilience Hub app.
     */
    override suspend fun putDraftAppVersionTemplate(input: PutDraftAppVersionTemplateRequest): PutDraftAppVersionTemplateResponse {
        val op = SdkHttpOperation.build<PutDraftAppVersionTemplateRequest, PutDraftAppVersionTemplateResponse> {
            serializer = PutDraftAppVersionTemplateOperationSerializer()
            deserializer = PutDraftAppVersionTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutDraftAppVersionTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes resource mappings from a draft application version.
     */
    override suspend fun removeDraftAppVersionResourceMappings(input: RemoveDraftAppVersionResourceMappingsRequest): RemoveDraftAppVersionResourceMappingsResponse {
        val op = SdkHttpOperation.build<RemoveDraftAppVersionResourceMappingsRequest, RemoveDraftAppVersionResourceMappingsResponse> {
            serializer = RemoveDraftAppVersionResourceMappingsOperationSerializer()
            deserializer = RemoveDraftAppVersionResourceMappingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveDraftAppVersionResourceMappings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Resolves the resources for an application version.
     */
    override suspend fun resolveAppVersionResources(input: ResolveAppVersionResourcesRequest): ResolveAppVersionResourcesResponse {
        val op = SdkHttpOperation.build<ResolveAppVersionResourcesRequest, ResolveAppVersionResourcesResponse> {
            serializer = ResolveAppVersionResourcesOperationSerializer()
            deserializer = ResolveAppVersionResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ResolveAppVersionResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new application assessment for an application.
     */
    override suspend fun startAppAssessment(input: StartAppAssessmentRequest): StartAppAssessmentResponse {
        val op = SdkHttpOperation.build<StartAppAssessmentRequest, StartAppAssessmentResponse> {
            serializer = StartAppAssessmentOperationSerializer()
            deserializer = StartAppAssessmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartAppAssessment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies one or more tags to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an application.
     */
    override suspend fun updateApp(input: UpdateAppRequest): UpdateAppResponse {
        val op = SdkHttpOperation.build<UpdateAppRequest, UpdateAppResponse> {
            serializer = UpdateAppOperationSerializer()
            deserializer = UpdateAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a resiliency policy.
     */
    override suspend fun updateResiliencyPolicy(input: UpdateResiliencyPolicyRequest): UpdateResiliencyPolicyResponse {
        val op = SdkHttpOperation.build<UpdateResiliencyPolicyRequest, UpdateResiliencyPolicyResponse> {
            serializer = UpdateResiliencyPolicyOperationSerializer()
            deserializer = UpdateResiliencyPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateResiliencyPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "resiliencehub"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "resiliencehub")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
