// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.sdk.kotlin.services.rekognition.model.StartLabelDetectionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartLabelDetectionOperationDeserializer: HttpDeserializer.NonStreaming<StartLabelDetectionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StartLabelDetectionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartLabelDetectionError(context, call, payload)
        }
        val builder = StartLabelDetectionResponse.Builder()

        if (payload != null) {
            deserializeStartLabelDetectionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStartLabelDetectionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidS3ObjectException" -> InvalidS3ObjectExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "VideoTooLargeException" -> VideoTooLargeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IdempotentParameterMismatchException" -> IdempotentParameterMismatchExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartLabelDetectionOperationBody(builder: StartLabelDetectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(JOBID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
