// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.sdk.kotlin.services.rekognition.model.SearchUsersByImageResponse
import aws.sdk.kotlin.services.rekognition.model.SearchedFaceDetails
import aws.sdk.kotlin.services.rekognition.model.UnsearchedFace
import aws.sdk.kotlin.services.rekognition.model.UserMatch
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class SearchUsersByImageOperationDeserializer: HttpDeserializer.NonStreaming<SearchUsersByImageResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): SearchUsersByImageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSearchUsersByImageError(context, call, payload)
        }
        val builder = SearchUsersByImageResponse.Builder()

        if (payload != null) {
            deserializeSearchUsersByImageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwSearchUsersByImageError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidS3ObjectException" -> InvalidS3ObjectExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ImageTooLargeException" -> ImageTooLargeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidImageFormatException" -> InvalidImageFormatExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSearchUsersByImageOperationBody(builder: SearchUsersByImageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FACEMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FaceModelVersion"))
    val SEARCHEDFACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SearchedFace"))
    val UNSEARCHEDFACES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnsearchedFaces"))
    val USERMATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UserMatches"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FACEMODELVERSION_DESCRIPTOR)
        field(SEARCHEDFACE_DESCRIPTOR)
        field(UNSEARCHEDFACES_DESCRIPTOR)
        field(USERMATCHES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FACEMODELVERSION_DESCRIPTOR.index -> builder.faceModelVersion = deserializeString()
                SEARCHEDFACE_DESCRIPTOR.index -> builder.searchedFace = deserializeSearchedFaceDetailsDocument(deserializer)
                UNSEARCHEDFACES_DESCRIPTOR.index -> builder.unsearchedFaces =
                    deserializer.deserializeList(UNSEARCHEDFACES_DESCRIPTOR) {
                        val col0 = mutableListOf<UnsearchedFace>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnsearchedFaceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USERMATCHES_DESCRIPTOR.index -> builder.userMatches =
                    deserializer.deserializeList(USERMATCHES_DESCRIPTOR) {
                        val col0 = mutableListOf<UserMatch>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUserMatchDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
