// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.FaceRecord
import aws.sdk.kotlin.services.rekognition.model.IndexFacesResponse
import aws.sdk.kotlin.services.rekognition.model.OrientationCorrection
import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.sdk.kotlin.services.rekognition.model.UnindexedFace
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class IndexFacesOperationDeserializer: HttpDeserializer.NonStreaming<IndexFacesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): IndexFacesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwIndexFacesError(context, call, payload)
        }
        val builder = IndexFacesResponse.Builder()

        if (payload != null) {
            deserializeIndexFacesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwIndexFacesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidS3ObjectException" -> InvalidS3ObjectExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ImageTooLargeException" -> ImageTooLargeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidImageFormatException" -> InvalidImageFormatExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeIndexFacesOperationBody(builder: IndexFacesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FACEMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FaceModelVersion"))
    val FACERECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FaceRecords"))
    val ORIENTATIONCORRECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("OrientationCorrection"))
    val UNINDEXEDFACES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnindexedFaces"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FACEMODELVERSION_DESCRIPTOR)
        field(FACERECORDS_DESCRIPTOR)
        field(ORIENTATIONCORRECTION_DESCRIPTOR)
        field(UNINDEXEDFACES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FACEMODELVERSION_DESCRIPTOR.index -> builder.faceModelVersion = deserializeString()
                FACERECORDS_DESCRIPTOR.index -> builder.faceRecords =
                    deserializer.deserializeList(FACERECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<FaceRecord>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFaceRecordDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ORIENTATIONCORRECTION_DESCRIPTOR.index -> builder.orientationCorrection = deserializeString().let { OrientationCorrection.fromValue(it) }
                UNINDEXEDFACES_DESCRIPTOR.index -> builder.unindexedFaces =
                    deserializer.deserializeList(UNINDEXEDFACES_DESCRIPTOR) {
                        val col0 = mutableListOf<UnindexedFace>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnindexedFaceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
