// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.AuditImage
import aws.sdk.kotlin.services.rekognition.model.GetFaceLivenessSessionResultsResponse
import aws.sdk.kotlin.services.rekognition.model.LivenessSessionStatus
import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetFaceLivenessSessionResultsOperationDeserializer: HttpDeserializer.NonStreaming<GetFaceLivenessSessionResultsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetFaceLivenessSessionResultsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetFaceLivenessSessionResultsError(context, call, payload)
        }
        val builder = GetFaceLivenessSessionResultsResponse.Builder()

        if (payload != null) {
            deserializeGetFaceLivenessSessionResultsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetFaceLivenessSessionResultsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SessionNotFoundException" -> SessionNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFaceLivenessSessionResultsOperationBody(builder: GetFaceLivenessSessionResultsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUDITIMAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AuditImages"))
    val CONFIDENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Float, JsonSerialName("Confidence"))
    val REFERENCEIMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ReferenceImage"))
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SessionId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUDITIMAGES_DESCRIPTOR)
        field(CONFIDENCE_DESCRIPTOR)
        field(REFERENCEIMAGE_DESCRIPTOR)
        field(SESSIONID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUDITIMAGES_DESCRIPTOR.index -> builder.auditImages =
                    deserializer.deserializeList(AUDITIMAGES_DESCRIPTOR) {
                        val col0 = mutableListOf<AuditImage>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAuditImageDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CONFIDENCE_DESCRIPTOR.index -> builder.confidence = deserializeFloat()
                REFERENCEIMAGE_DESCRIPTOR.index -> builder.referenceImage = deserializeAuditImageDocument(deserializer)
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { LivenessSessionStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
