// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.ContentModerationDetection
import aws.sdk.kotlin.services.rekognition.model.GetContentModerationRequestMetadata
import aws.sdk.kotlin.services.rekognition.model.GetContentModerationResponse
import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.sdk.kotlin.services.rekognition.model.Video
import aws.sdk.kotlin.services.rekognition.model.VideoJobStatus
import aws.sdk.kotlin.services.rekognition.model.VideoMetadata
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetContentModerationOperationDeserializer: HttpDeserializer.NonStreaming<GetContentModerationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetContentModerationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetContentModerationError(context, call, payload)
        }
        val builder = GetContentModerationResponse.Builder()

        if (payload != null) {
            deserializeGetContentModerationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetContentModerationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPaginationTokenException" -> InvalidPaginationTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetContentModerationOperationBody(builder: GetContentModerationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val GETREQUESTMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("GetRequestMetadata"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobId"))
    val JOBSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("JobStatus"))
    val JOBTAG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("JobTag"))
    val MODERATIONLABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ModerationLabels"))
    val MODERATIONMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModerationModelVersion"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusMessage"))
    val VIDEO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Video"))
    val VIDEOMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("VideoMetadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(GETREQUESTMETADATA_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(JOBSTATUS_DESCRIPTOR)
        field(JOBTAG_DESCRIPTOR)
        field(MODERATIONLABELS_DESCRIPTOR)
        field(MODERATIONMODELVERSION_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
        field(VIDEO_DESCRIPTOR)
        field(VIDEOMETADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                GETREQUESTMETADATA_DESCRIPTOR.index -> builder.getRequestMetadata = deserializeGetContentModerationRequestMetadataDocument(deserializer)
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                JOBSTATUS_DESCRIPTOR.index -> builder.jobStatus = deserializeString().let { VideoJobStatus.fromValue(it) }
                JOBTAG_DESCRIPTOR.index -> builder.jobTag = deserializeString()
                MODERATIONLABELS_DESCRIPTOR.index -> builder.moderationLabels =
                    deserializer.deserializeList(MODERATIONLABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<ContentModerationDetection>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeContentModerationDetectionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MODERATIONMODELVERSION_DESCRIPTOR.index -> builder.moderationModelVersion = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                VIDEO_DESCRIPTOR.index -> builder.video = deserializeVideoDocument(deserializer)
                VIDEOMETADATA_DESCRIPTOR.index -> builder.videoMetadata = deserializeVideoMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
