// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.DetectTextResponse
import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.sdk.kotlin.services.rekognition.model.TextDetection
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DetectTextOperationDeserializer: HttpDeserializer.NonStreaming<DetectTextResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DetectTextResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDetectTextError(context, call, payload)
        }
        val builder = DetectTextResponse.Builder()

        if (payload != null) {
            deserializeDetectTextOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDetectTextError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidS3ObjectException" -> InvalidS3ObjectExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ImageTooLargeException" -> ImageTooLargeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidImageFormatException" -> InvalidImageFormatExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDetectTextOperationBody(builder: DetectTextResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TEXTDETECTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TextDetections"))
    val TEXTMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TextModelVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TEXTDETECTIONS_DESCRIPTOR)
        field(TEXTMODELVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TEXTDETECTIONS_DESCRIPTOR.index -> builder.textDetections =
                    deserializer.deserializeList(TEXTDETECTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<TextDetection>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTextDetectionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TEXTMODELVERSION_DESCRIPTOR.index -> builder.textModelVersion = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
