// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.ContentType
import aws.sdk.kotlin.services.rekognition.model.DetectModerationLabelsResponse
import aws.sdk.kotlin.services.rekognition.model.HumanLoopActivationOutput
import aws.sdk.kotlin.services.rekognition.model.ModerationLabel
import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DetectModerationLabelsOperationDeserializer: HttpDeserializer.NonStreaming<DetectModerationLabelsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DetectModerationLabelsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDetectModerationLabelsError(context, call, payload)
        }
        val builder = DetectModerationLabelsResponse.Builder()

        if (payload != null) {
            deserializeDetectModerationLabelsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDetectModerationLabelsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidS3ObjectException" -> InvalidS3ObjectExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotReadyException" -> ResourceNotReadyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ImageTooLargeException" -> ImageTooLargeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidImageFormatException" -> InvalidImageFormatExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "HumanLoopQuotaExceededException" -> HumanLoopQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDetectModerationLabelsOperationBody(builder: DetectModerationLabelsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTENTTYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ContentTypes"))
    val HUMANLOOPACTIVATIONOUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HumanLoopActivationOutput"))
    val MODERATIONLABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ModerationLabels"))
    val MODERATIONMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ModerationModelVersion"))
    val PROJECTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProjectVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENTTYPES_DESCRIPTOR)
        field(HUMANLOOPACTIVATIONOUTPUT_DESCRIPTOR)
        field(MODERATIONLABELS_DESCRIPTOR)
        field(MODERATIONMODELVERSION_DESCRIPTOR)
        field(PROJECTVERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTENTTYPES_DESCRIPTOR.index -> builder.contentTypes =
                    deserializer.deserializeList(CONTENTTYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<ContentType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeContentTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                HUMANLOOPACTIVATIONOUTPUT_DESCRIPTOR.index -> builder.humanLoopActivationOutput = deserializeHumanLoopActivationOutputDocument(deserializer)
                MODERATIONLABELS_DESCRIPTOR.index -> builder.moderationLabels =
                    deserializer.deserializeList(MODERATIONLABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<ModerationLabel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeModerationLabelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MODERATIONMODELVERSION_DESCRIPTOR.index -> builder.moderationModelVersion = deserializeString()
                PROJECTVERSION_DESCRIPTOR.index -> builder.projectVersion = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
