// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.DetectLabelsImageProperties
import aws.sdk.kotlin.services.rekognition.model.DetectLabelsResponse
import aws.sdk.kotlin.services.rekognition.model.Label
import aws.sdk.kotlin.services.rekognition.model.OrientationCorrection
import aws.sdk.kotlin.services.rekognition.model.RekognitionException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DetectLabelsOperationDeserializer: HttpDeserializer.NonStreaming<DetectLabelsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DetectLabelsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDetectLabelsError(context, call, payload)
        }
        val builder = DetectLabelsResponse.Builder()

        if (payload != null) {
            deserializeDetectLabelsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDetectLabelsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw RekognitionException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidS3ObjectException" -> InvalidS3ObjectExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ProvisionedThroughputExceededException" -> ProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ImageTooLargeException" -> ImageTooLargeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidImageFormatException" -> InvalidImageFormatExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> RekognitionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDetectLabelsOperationBody(builder: DetectLabelsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val IMAGEPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ImageProperties"))
    val LABELMODELVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LabelModelVersion"))
    val LABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Labels"))
    val ORIENTATIONCORRECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("OrientationCorrection"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IMAGEPROPERTIES_DESCRIPTOR)
        field(LABELMODELVERSION_DESCRIPTOR)
        field(LABELS_DESCRIPTOR)
        field(ORIENTATIONCORRECTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                IMAGEPROPERTIES_DESCRIPTOR.index -> builder.imageProperties = deserializeDetectLabelsImagePropertiesDocument(deserializer)
                LABELMODELVERSION_DESCRIPTOR.index -> builder.labelModelVersion = deserializeString()
                LABELS_DESCRIPTOR.index -> builder.labels =
                    deserializer.deserializeList(LABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<Label>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLabelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ORIENTATIONCORRECTION_DESCRIPTOR.index -> builder.orientationCorrection = deserializeString().let { OrientationCorrection.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
