// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.serde

import aws.sdk.kotlin.services.rekognition.model.CreateProjectVersionRequest
import aws.sdk.kotlin.services.rekognition.model.CustomizationFeatureConfig
import aws.sdk.kotlin.services.rekognition.model.OutputConfig
import aws.sdk.kotlin.services.rekognition.model.TestingData
import aws.sdk.kotlin.services.rekognition.model.TrainingData
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateProjectVersionOperationSerializer: HttpSerializer.NonStreaming<CreateProjectVersionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateProjectVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateProjectVersionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateProjectVersionOperationBody(context: ExecutionContext, input: CreateProjectVersionRequest): ByteArray {
    val serializer = JsonSerializer()
    val FEATURECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FeatureConfig"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val OUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OutputConfig"))
    val PROJECTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProjectArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val TESTINGDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TestingData"))
    val TRAININGDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TrainingData"))
    val VERSIONDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionDescription"))
    val VERSIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FEATURECONFIG_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(OUTPUTCONFIG_DESCRIPTOR)
        field(PROJECTARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TESTINGDATA_DESCRIPTOR)
        field(TRAININGDATA_DESCRIPTOR)
        field(VERSIONDESCRIPTION_DESCRIPTOR)
        field(VERSIONNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.featureConfig?.let { field(FEATURECONFIG_DESCRIPTOR, it, ::serializeCustomizationFeatureConfigDocument) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.outputConfig?.let { field(OUTPUTCONFIG_DESCRIPTOR, it, ::serializeOutputConfigDocument) }
        input.projectArn?.let { field(PROJECTARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.testingData?.let { field(TESTINGDATA_DESCRIPTOR, it, ::serializeTestingDataDocument) }
        input.trainingData?.let { field(TRAININGDATA_DESCRIPTOR, it, ::serializeTrainingDataDocument) }
        input.versionDescription?.let { field(VERSIONDESCRIPTION_DESCRIPTOR, it) }
        input.versionName?.let { field(VERSIONNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
