// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.paginators

import aws.sdk.kotlin.services.rekognition.RekognitionClient
import aws.sdk.kotlin.services.rekognition.model.DatasetLabelDescription
import aws.sdk.kotlin.services.rekognition.model.DescribeProjectVersionsRequest
import aws.sdk.kotlin.services.rekognition.model.DescribeProjectVersionsResponse
import aws.sdk.kotlin.services.rekognition.model.DescribeProjectsRequest
import aws.sdk.kotlin.services.rekognition.model.DescribeProjectsResponse
import aws.sdk.kotlin.services.rekognition.model.Face
import aws.sdk.kotlin.services.rekognition.model.GetCelebrityRecognitionRequest
import aws.sdk.kotlin.services.rekognition.model.GetCelebrityRecognitionResponse
import aws.sdk.kotlin.services.rekognition.model.GetContentModerationRequest
import aws.sdk.kotlin.services.rekognition.model.GetContentModerationResponse
import aws.sdk.kotlin.services.rekognition.model.GetFaceDetectionRequest
import aws.sdk.kotlin.services.rekognition.model.GetFaceDetectionResponse
import aws.sdk.kotlin.services.rekognition.model.GetFaceSearchRequest
import aws.sdk.kotlin.services.rekognition.model.GetFaceSearchResponse
import aws.sdk.kotlin.services.rekognition.model.GetLabelDetectionRequest
import aws.sdk.kotlin.services.rekognition.model.GetLabelDetectionResponse
import aws.sdk.kotlin.services.rekognition.model.GetPersonTrackingRequest
import aws.sdk.kotlin.services.rekognition.model.GetPersonTrackingResponse
import aws.sdk.kotlin.services.rekognition.model.GetSegmentDetectionRequest
import aws.sdk.kotlin.services.rekognition.model.GetSegmentDetectionResponse
import aws.sdk.kotlin.services.rekognition.model.GetTextDetectionRequest
import aws.sdk.kotlin.services.rekognition.model.GetTextDetectionResponse
import aws.sdk.kotlin.services.rekognition.model.ListCollectionsRequest
import aws.sdk.kotlin.services.rekognition.model.ListCollectionsResponse
import aws.sdk.kotlin.services.rekognition.model.ListDatasetEntriesRequest
import aws.sdk.kotlin.services.rekognition.model.ListDatasetEntriesResponse
import aws.sdk.kotlin.services.rekognition.model.ListDatasetLabelsRequest
import aws.sdk.kotlin.services.rekognition.model.ListDatasetLabelsResponse
import aws.sdk.kotlin.services.rekognition.model.ListFacesRequest
import aws.sdk.kotlin.services.rekognition.model.ListFacesResponse
import aws.sdk.kotlin.services.rekognition.model.ListMediaAnalysisJobsRequest
import aws.sdk.kotlin.services.rekognition.model.ListMediaAnalysisJobsResponse
import aws.sdk.kotlin.services.rekognition.model.ListProjectPoliciesRequest
import aws.sdk.kotlin.services.rekognition.model.ListProjectPoliciesResponse
import aws.sdk.kotlin.services.rekognition.model.ListStreamProcessorsRequest
import aws.sdk.kotlin.services.rekognition.model.ListStreamProcessorsResponse
import aws.sdk.kotlin.services.rekognition.model.ListUsersRequest
import aws.sdk.kotlin.services.rekognition.model.ListUsersResponse
import aws.sdk.kotlin.services.rekognition.model.ProjectDescription
import aws.sdk.kotlin.services.rekognition.model.ProjectPolicy
import aws.sdk.kotlin.services.rekognition.model.ProjectVersionDescription
import aws.sdk.kotlin.services.rekognition.model.User
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeProjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeProjectsResponse]
 */
public fun RekognitionClient.describeProjectsPaginated(initialRequest: DescribeProjectsRequest = DescribeProjectsRequest { }): Flow<DescribeProjectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeProjectsPaginated.describeProjects(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeProjectsResponse]
 */
public fun RekognitionClient.describeProjectsPaginated(block: DescribeProjectsRequest.Builder.() -> Unit): Flow<DescribeProjectsResponse> =
    describeProjectsPaginated(DescribeProjectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeProjectsPaginated]
 * to access the nested member [ProjectDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProjectDescription]
 */
@JvmName("describeProjectsResponseProjectDescription")
public fun Flow<DescribeProjectsResponse>.projectDescriptions(): Flow<ProjectDescription> =
    transform() { response ->
        response.projectDescriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeProjectVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeProjectVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeProjectVersionsResponse]
 */
public fun RekognitionClient.describeProjectVersionsPaginated(initialRequest: DescribeProjectVersionsRequest): Flow<DescribeProjectVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeProjectVersionsPaginated.describeProjectVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeProjectVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeProjectVersionsResponse]
 */
public fun RekognitionClient.describeProjectVersionsPaginated(block: DescribeProjectVersionsRequest.Builder.() -> Unit): Flow<DescribeProjectVersionsResponse> =
    describeProjectVersionsPaginated(DescribeProjectVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeProjectVersionsPaginated]
 * to access the nested member [ProjectVersionDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProjectVersionDescription]
 */
@JvmName("describeProjectVersionsResponseProjectVersionDescription")
public fun Flow<DescribeProjectVersionsResponse>.projectVersionDescriptions(): Flow<ProjectVersionDescription> =
    transform() { response ->
        response.projectVersionDescriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetCelebrityRecognitionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCelebrityRecognitionRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCelebrityRecognitionResponse]
 */
public fun RekognitionClient.getCelebrityRecognitionPaginated(initialRequest: GetCelebrityRecognitionRequest): Flow<GetCelebrityRecognitionResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCelebrityRecognitionPaginated.getCelebrityRecognition(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetCelebrityRecognitionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCelebrityRecognitionResponse]
 */
public fun RekognitionClient.getCelebrityRecognitionPaginated(block: GetCelebrityRecognitionRequest.Builder.() -> Unit): Flow<GetCelebrityRecognitionResponse> =
    getCelebrityRecognitionPaginated(GetCelebrityRecognitionRequest.Builder().apply(block).build())

/**
 * Paginate over [GetContentModerationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetContentModerationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetContentModerationResponse]
 */
public fun RekognitionClient.getContentModerationPaginated(initialRequest: GetContentModerationRequest): Flow<GetContentModerationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getContentModerationPaginated.getContentModeration(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetContentModerationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetContentModerationResponse]
 */
public fun RekognitionClient.getContentModerationPaginated(block: GetContentModerationRequest.Builder.() -> Unit): Flow<GetContentModerationResponse> =
    getContentModerationPaginated(GetContentModerationRequest.Builder().apply(block).build())

/**
 * Paginate over [GetFaceDetectionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetFaceDetectionRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFaceDetectionResponse]
 */
public fun RekognitionClient.getFaceDetectionPaginated(initialRequest: GetFaceDetectionRequest): Flow<GetFaceDetectionResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getFaceDetectionPaginated.getFaceDetection(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetFaceDetectionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFaceDetectionResponse]
 */
public fun RekognitionClient.getFaceDetectionPaginated(block: GetFaceDetectionRequest.Builder.() -> Unit): Flow<GetFaceDetectionResponse> =
    getFaceDetectionPaginated(GetFaceDetectionRequest.Builder().apply(block).build())

/**
 * Paginate over [GetFaceSearchResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetFaceSearchRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFaceSearchResponse]
 */
public fun RekognitionClient.getFaceSearchPaginated(initialRequest: GetFaceSearchRequest): Flow<GetFaceSearchResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getFaceSearchPaginated.getFaceSearch(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetFaceSearchResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetFaceSearchResponse]
 */
public fun RekognitionClient.getFaceSearchPaginated(block: GetFaceSearchRequest.Builder.() -> Unit): Flow<GetFaceSearchResponse> =
    getFaceSearchPaginated(GetFaceSearchRequest.Builder().apply(block).build())

/**
 * Paginate over [GetLabelDetectionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetLabelDetectionRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetLabelDetectionResponse]
 */
public fun RekognitionClient.getLabelDetectionPaginated(initialRequest: GetLabelDetectionRequest): Flow<GetLabelDetectionResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getLabelDetectionPaginated.getLabelDetection(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetLabelDetectionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetLabelDetectionResponse]
 */
public fun RekognitionClient.getLabelDetectionPaginated(block: GetLabelDetectionRequest.Builder.() -> Unit): Flow<GetLabelDetectionResponse> =
    getLabelDetectionPaginated(GetLabelDetectionRequest.Builder().apply(block).build())

/**
 * Paginate over [GetPersonTrackingResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetPersonTrackingRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetPersonTrackingResponse]
 */
public fun RekognitionClient.getPersonTrackingPaginated(initialRequest: GetPersonTrackingRequest): Flow<GetPersonTrackingResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getPersonTrackingPaginated.getPersonTracking(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetPersonTrackingResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetPersonTrackingResponse]
 */
public fun RekognitionClient.getPersonTrackingPaginated(block: GetPersonTrackingRequest.Builder.() -> Unit): Flow<GetPersonTrackingResponse> =
    getPersonTrackingPaginated(GetPersonTrackingRequest.Builder().apply(block).build())

/**
 * Paginate over [GetSegmentDetectionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetSegmentDetectionRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSegmentDetectionResponse]
 */
public fun RekognitionClient.getSegmentDetectionPaginated(initialRequest: GetSegmentDetectionRequest): Flow<GetSegmentDetectionResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getSegmentDetectionPaginated.getSegmentDetection(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetSegmentDetectionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSegmentDetectionResponse]
 */
public fun RekognitionClient.getSegmentDetectionPaginated(block: GetSegmentDetectionRequest.Builder.() -> Unit): Flow<GetSegmentDetectionResponse> =
    getSegmentDetectionPaginated(GetSegmentDetectionRequest.Builder().apply(block).build())

/**
 * Paginate over [GetTextDetectionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetTextDetectionRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTextDetectionResponse]
 */
public fun RekognitionClient.getTextDetectionPaginated(initialRequest: GetTextDetectionRequest): Flow<GetTextDetectionResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getTextDetectionPaginated.getTextDetection(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetTextDetectionResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTextDetectionResponse]
 */
public fun RekognitionClient.getTextDetectionPaginated(block: GetTextDetectionRequest.Builder.() -> Unit): Flow<GetTextDetectionResponse> =
    getTextDetectionPaginated(GetTextDetectionRequest.Builder().apply(block).build())

/**
 * Paginate over [ListCollectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCollectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCollectionsResponse]
 */
public fun RekognitionClient.listCollectionsPaginated(initialRequest: ListCollectionsRequest = ListCollectionsRequest { }): Flow<ListCollectionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCollectionsPaginated.listCollections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCollectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCollectionsResponse]
 */
public fun RekognitionClient.listCollectionsPaginated(block: ListCollectionsRequest.Builder.() -> Unit): Flow<ListCollectionsResponse> =
    listCollectionsPaginated(ListCollectionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCollectionsPaginated]
 * to access the nested member [CollectionId]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CollectionId]
 */
@JvmName("listCollectionsResponseCollectionId")
public fun Flow<ListCollectionsResponse>.collectionIds(): Flow<String> =
    transform() { response ->
        response.collectionIds?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatasetEntriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetEntriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetEntriesResponse]
 */
public fun RekognitionClient.listDatasetEntriesPaginated(initialRequest: ListDatasetEntriesRequest): Flow<ListDatasetEntriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetEntriesPaginated.listDatasetEntries(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetEntriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetEntriesResponse]
 */
public fun RekognitionClient.listDatasetEntriesPaginated(block: ListDatasetEntriesRequest.Builder.() -> Unit): Flow<ListDatasetEntriesResponse> =
    listDatasetEntriesPaginated(ListDatasetEntriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetEntriesPaginated]
 * to access the nested member [DatasetEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetEntry]
 */
@JvmName("listDatasetEntriesResponseDatasetEntry")
public fun Flow<ListDatasetEntriesResponse>.datasetEntries(): Flow<String> =
    transform() { response ->
        response.datasetEntries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDatasetLabelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDatasetLabelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetLabelsResponse]
 */
public fun RekognitionClient.listDatasetLabelsPaginated(initialRequest: ListDatasetLabelsRequest): Flow<ListDatasetLabelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDatasetLabelsPaginated.listDatasetLabels(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDatasetLabelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDatasetLabelsResponse]
 */
public fun RekognitionClient.listDatasetLabelsPaginated(block: ListDatasetLabelsRequest.Builder.() -> Unit): Flow<ListDatasetLabelsResponse> =
    listDatasetLabelsPaginated(ListDatasetLabelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDatasetLabelsPaginated]
 * to access the nested member [DatasetLabelDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DatasetLabelDescription]
 */
@JvmName("listDatasetLabelsResponseDatasetLabelDescription")
public fun Flow<ListDatasetLabelsResponse>.datasetLabelDescriptions(): Flow<DatasetLabelDescription> =
    transform() { response ->
        response.datasetLabelDescriptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFacesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFacesResponse]
 */
public fun RekognitionClient.listFacesPaginated(initialRequest: ListFacesRequest): Flow<ListFacesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFacesPaginated.listFaces(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFacesResponse]
 */
public fun RekognitionClient.listFacesPaginated(block: ListFacesRequest.Builder.() -> Unit): Flow<ListFacesResponse> =
    listFacesPaginated(ListFacesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFacesPaginated]
 * to access the nested member [Face]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Face]
 */
@JvmName("listFacesResponseFace")
public fun Flow<ListFacesResponse>.faces(): Flow<Face> =
    transform() { response ->
        response.faces?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMediaAnalysisJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMediaAnalysisJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMediaAnalysisJobsResponse]
 */
public fun RekognitionClient.listMediaAnalysisJobsPaginated(initialRequest: ListMediaAnalysisJobsRequest = ListMediaAnalysisJobsRequest { }): Flow<ListMediaAnalysisJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMediaAnalysisJobsPaginated.listMediaAnalysisJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMediaAnalysisJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMediaAnalysisJobsResponse]
 */
public fun RekognitionClient.listMediaAnalysisJobsPaginated(block: ListMediaAnalysisJobsRequest.Builder.() -> Unit): Flow<ListMediaAnalysisJobsResponse> =
    listMediaAnalysisJobsPaginated(ListMediaAnalysisJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListProjectPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProjectPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectPoliciesResponse]
 */
public fun RekognitionClient.listProjectPoliciesPaginated(initialRequest: ListProjectPoliciesRequest): Flow<ListProjectPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProjectPoliciesPaginated.listProjectPolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProjectPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectPoliciesResponse]
 */
public fun RekognitionClient.listProjectPoliciesPaginated(block: ListProjectPoliciesRequest.Builder.() -> Unit): Flow<ListProjectPoliciesResponse> =
    listProjectPoliciesPaginated(ListProjectPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProjectPoliciesPaginated]
 * to access the nested member [ProjectPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProjectPolicy]
 */
@JvmName("listProjectPoliciesResponseProjectPolicy")
public fun Flow<ListProjectPoliciesResponse>.projectPolicies(): Flow<ProjectPolicy> =
    transform() { response ->
        response.projectPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStreamProcessorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStreamProcessorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStreamProcessorsResponse]
 */
public fun RekognitionClient.listStreamProcessorsPaginated(initialRequest: ListStreamProcessorsRequest = ListStreamProcessorsRequest { }): Flow<ListStreamProcessorsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStreamProcessorsPaginated.listStreamProcessors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStreamProcessorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStreamProcessorsResponse]
 */
public fun RekognitionClient.listStreamProcessorsPaginated(block: ListStreamProcessorsRequest.Builder.() -> Unit): Flow<ListStreamProcessorsResponse> =
    listStreamProcessorsPaginated(ListStreamProcessorsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun RekognitionClient.listUsersPaginated(initialRequest: ListUsersRequest): Flow<ListUsersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUsersPaginated.listUsers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun RekognitionClient.listUsersPaginated(block: ListUsersRequest.Builder.() -> Unit): Flow<ListUsersResponse> =
    listUsersPaginated(ListUsersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUsersPaginated]
 * to access the nested member [User]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [User]
 */
@JvmName("listUsersResponseUser")
public fun Flow<ListUsersResponse>.users(): Flow<User> =
    transform() { response ->
        response.users?.forEach {
            emit(it)
        }
    }
