// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the Amazon S3 bucket location of the validation data for a model training job.
 *
 * The validation data includes error information for individual JSON Lines in the dataset. For more information, see *Debugging a Failed Model Training* in the Amazon Rekognition Custom Labels Developer Guide.
 *
 * You get the `ValidationData` object for the training dataset (TrainingDataResult) and the test dataset (TestingDataResult) by calling DescribeProjectVersions.
 *
 * The assets array contains a single Asset object. The GroundTruthManifest field of the Asset object contains the S3 bucket location of the validation data.
 */
public class ValidationData private constructor(builder: Builder) {
    /**
     * The assets that comprise the validation data.
     */
    public val assets: List<Asset>? = builder.assets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.ValidationData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidationData(")
        append("assets=$assets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assets?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidationData

        if (assets != other.assets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.ValidationData = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The assets that comprise the validation data.
         */
        public var assets: List<Asset>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.ValidationData) : this() {
            this.assets = x.assets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.ValidationData = ValidationData(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
