// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A face that IndexFaces detected, but didn't index. Use the `Reasons` response attribute to determine why a face wasn't indexed.
 */
public class UnindexedFace private constructor(builder: Builder) {
    /**
     * The structure that contains attributes of a face that `IndexFaces`detected, but didn't index.
     */
    public val faceDetail: aws.sdk.kotlin.services.rekognition.model.FaceDetail? = builder.faceDetail
    /**
     * An array of reasons that specify why a face wasn't indexed.
     * + EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away from the camera.
     * + EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the `MaxFaces` input parameter for `IndexFaces`.
     * + LOW_BRIGHTNESS - The image is too dark.
     * + LOW_SHARPNESS - The image is too blurry.
     * + LOW_CONFIDENCE - The face was detected with a low confidence.
     * + SMALL_BOUNDING_BOX - The bounding box around the face is too small.
     */
    public val reasons: List<Reason>? = builder.reasons

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.UnindexedFace = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UnindexedFace(")
        append("faceDetail=$faceDetail,")
        append("reasons=$reasons")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = faceDetail?.hashCode() ?: 0
        result = 31 * result + (reasons?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UnindexedFace

        if (faceDetail != other.faceDetail) return false
        if (reasons != other.reasons) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.UnindexedFace = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The structure that contains attributes of a face that `IndexFaces`detected, but didn't index.
         */
        public var faceDetail: aws.sdk.kotlin.services.rekognition.model.FaceDetail? = null
        /**
         * An array of reasons that specify why a face wasn't indexed.
         * + EXTREME_POSE - The face is at a pose that can't be detected. For example, the head is turned too far away from the camera.
         * + EXCEEDS_MAX_FACES - The number of faces detected is already higher than that specified by the `MaxFaces` input parameter for `IndexFaces`.
         * + LOW_BRIGHTNESS - The image is too dark.
         * + LOW_SHARPNESS - The image is too blurry.
         * + LOW_CONFIDENCE - The face was detected with a low confidence.
         * + SMALL_BOUNDING_BOX - The bounding box around the face is too small.
         */
        public var reasons: List<Reason>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.UnindexedFace) : this() {
            this.faceDetail = x.faceDetail
            this.reasons = x.reasons
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.UnindexedFace = UnindexedFace(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.FaceDetail] inside the given [block]
         */
        public fun faceDetail(block: aws.sdk.kotlin.services.rekognition.model.FaceDetail.Builder.() -> kotlin.Unit) {
            this.faceDetail = aws.sdk.kotlin.services.rekognition.model.FaceDetail.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
