// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Sagemaker Groundtruth format manifest files for the input, output and validation datasets that are used and created during testing.
 */
public class TestingDataResult private constructor(builder: Builder) {
    /**
     * The testing dataset that was supplied for training.
     */
    public val input: aws.sdk.kotlin.services.rekognition.model.TestingData? = builder.input
    /**
     * The subset of the dataset that was actually tested. Some images (assets) might not be tested due to file formatting and other issues.
     */
    public val output: aws.sdk.kotlin.services.rekognition.model.TestingData? = builder.output
    /**
     * The location of the data validation manifest. The data validation manifest is created for the test dataset during model training.
     */
    public val validation: aws.sdk.kotlin.services.rekognition.model.ValidationData? = builder.validation

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.TestingDataResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestingDataResult(")
        append("input=$input,")
        append("output=$output,")
        append("validation=$validation")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = input?.hashCode() ?: 0
        result = 31 * result + (output?.hashCode() ?: 0)
        result = 31 * result + (validation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestingDataResult

        if (input != other.input) return false
        if (output != other.output) return false
        if (validation != other.validation) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.TestingDataResult = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The testing dataset that was supplied for training.
         */
        public var input: aws.sdk.kotlin.services.rekognition.model.TestingData? = null
        /**
         * The subset of the dataset that was actually tested. Some images (assets) might not be tested due to file formatting and other issues.
         */
        public var output: aws.sdk.kotlin.services.rekognition.model.TestingData? = null
        /**
         * The location of the data validation manifest. The data validation manifest is created for the test dataset during model training.
         */
        public var validation: aws.sdk.kotlin.services.rekognition.model.ValidationData? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.TestingDataResult) : this() {
            this.input = x.input
            this.output = x.output
            this.validation = x.validation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.TestingDataResult = TestingDataResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.TestingData] inside the given [block]
         */
        public fun input(block: aws.sdk.kotlin.services.rekognition.model.TestingData.Builder.() -> kotlin.Unit) {
            this.input = aws.sdk.kotlin.services.rekognition.model.TestingData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.TestingData] inside the given [block]
         */
        public fun output(block: aws.sdk.kotlin.services.rekognition.model.TestingData.Builder.() -> kotlin.Unit) {
            this.output = aws.sdk.kotlin.services.rekognition.model.TestingData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.ValidationData] inside the given [block]
         */
        public fun validation(block: aws.sdk.kotlin.services.rekognition.model.ValidationData.Builder.() -> kotlin.Unit) {
            this.validation = aws.sdk.kotlin.services.rekognition.model.ValidationData.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
