// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the Amazon Kinesis Data Streams stream to which a Amazon Rekognition Video stream processor streams the results of a video analysis. For more information, see CreateStreamProcessor in the Amazon Rekognition Developer Guide.
 */
public class StreamProcessorOutput private constructor(builder: Builder) {
    /**
     * The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results.
     */
    public val kinesisDataStream: aws.sdk.kotlin.services.rekognition.model.KinesisDataStream? = builder.kinesisDataStream
    /**
     * The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation.
     */
    public val s3Destination: aws.sdk.kotlin.services.rekognition.model.S3Destination? = builder.s3Destination

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.StreamProcessorOutput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamProcessorOutput(")
        append("kinesisDataStream=$kinesisDataStream,")
        append("s3Destination=$s3Destination")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kinesisDataStream?.hashCode() ?: 0
        result = 31 * result + (s3Destination?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamProcessorOutput

        if (kinesisDataStream != other.kinesisDataStream) return false
        if (s3Destination != other.s3Destination) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.StreamProcessorOutput = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream processor streams the analysis results.
         */
        public var kinesisDataStream: aws.sdk.kotlin.services.rekognition.model.KinesisDataStream? = null
        /**
         * The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation.
         */
        public var s3Destination: aws.sdk.kotlin.services.rekognition.model.S3Destination? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.StreamProcessorOutput) : this() {
            this.kinesisDataStream = x.kinesisDataStream
            this.s3Destination = x.s3Destination
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.StreamProcessorOutput = StreamProcessorOutput(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.KinesisDataStream] inside the given [block]
         */
        public fun kinesisDataStream(block: aws.sdk.kotlin.services.rekognition.model.KinesisDataStream.Builder.() -> kotlin.Unit) {
            this.kinesisDataStream = aws.sdk.kotlin.services.rekognition.model.KinesisDataStream.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.S3Destination] inside the given [block]
         */
        public fun s3Destination(block: aws.sdk.kotlin.services.rekognition.model.S3Destination.Builder.() -> kotlin.Unit) {
            this.s3Destination = aws.sdk.kotlin.services.rekognition.model.S3Destination.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
