// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartTextDetectionRequest private constructor(builder: Builder) {
    /**
     * Idempotent token used to identify the start request. If you use the same token with multiple `StartTextDetection` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidentaly started more than once.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Optional parameters that let you set criteria the text must meet to be included in your response.
     */
    public val filters: aws.sdk.kotlin.services.rekognition.model.StartTextDetectionFilters? = builder.filters
    /**
     * An identifier returned in the completion status published by your Amazon Simple Notification Service topic. For example, you can use `JobTag` to group related jobs and identify them in the completion notification.
     */
    public val jobTag: kotlin.String? = builder.jobTag
    /**
     * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status of a video analysis operation. For more information, see [Calling Amazon Rekognition Video operations](https://docs.aws.amazon.com/rekognition/latest/dg/api-video.html). Note that the Amazon SNS topic must have a topic name that begins with *AmazonRekognition* if you are using the AmazonRekognitionServiceRole permissions policy to access the topic. For more information, see [Giving access to multiple Amazon SNS topics](https://docs.aws.amazon.com/rekognition/latest/dg/api-video-roles.html#api-video-roles-all-topics).
     */
    public val notificationChannel: aws.sdk.kotlin.services.rekognition.model.NotificationChannel? = builder.notificationChannel
    /**
     * Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as StartLabelDetection use `Video` to specify a video for analysis. The supported file formats are .mp4, .mov and .avi.
     */
    public val video: aws.sdk.kotlin.services.rekognition.model.Video? = builder.video

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.StartTextDetectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartTextDetectionRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("filters=$filters,")
        append("jobTag=$jobTag,")
        append("notificationChannel=$notificationChannel,")
        append("video=$video")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (jobTag?.hashCode() ?: 0)
        result = 31 * result + (notificationChannel?.hashCode() ?: 0)
        result = 31 * result + (video?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartTextDetectionRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (filters != other.filters) return false
        if (jobTag != other.jobTag) return false
        if (notificationChannel != other.notificationChannel) return false
        if (video != other.video) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.StartTextDetectionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Idempotent token used to identify the start request. If you use the same token with multiple `StartTextDetection` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidentaly started more than once.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Optional parameters that let you set criteria the text must meet to be included in your response.
         */
        public var filters: aws.sdk.kotlin.services.rekognition.model.StartTextDetectionFilters? = null
        /**
         * An identifier returned in the completion status published by your Amazon Simple Notification Service topic. For example, you can use `JobTag` to group related jobs and identify them in the completion notification.
         */
        public var jobTag: kotlin.String? = null
        /**
         * The Amazon Simple Notification Service topic to which Amazon Rekognition publishes the completion status of a video analysis operation. For more information, see [Calling Amazon Rekognition Video operations](https://docs.aws.amazon.com/rekognition/latest/dg/api-video.html). Note that the Amazon SNS topic must have a topic name that begins with *AmazonRekognition* if you are using the AmazonRekognitionServiceRole permissions policy to access the topic. For more information, see [Giving access to multiple Amazon SNS topics](https://docs.aws.amazon.com/rekognition/latest/dg/api-video-roles.html#api-video-roles-all-topics).
         */
        public var notificationChannel: aws.sdk.kotlin.services.rekognition.model.NotificationChannel? = null
        /**
         * Video file stored in an Amazon S3 bucket. Amazon Rekognition video start operations such as StartLabelDetection use `Video` to specify a video for analysis. The supported file formats are .mp4, .mov and .avi.
         */
        public var video: aws.sdk.kotlin.services.rekognition.model.Video? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.StartTextDetectionRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.filters = x.filters
            this.jobTag = x.jobTag
            this.notificationChannel = x.notificationChannel
            this.video = x.video
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.StartTextDetectionRequest = StartTextDetectionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.StartTextDetectionFilters] inside the given [block]
         */
        public fun filters(block: aws.sdk.kotlin.services.rekognition.model.StartTextDetectionFilters.Builder.() -> kotlin.Unit) {
            this.filters = aws.sdk.kotlin.services.rekognition.model.StartTextDetectionFilters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.NotificationChannel] inside the given [block]
         */
        public fun notificationChannel(block: aws.sdk.kotlin.services.rekognition.model.NotificationChannel.Builder.() -> kotlin.Unit) {
            this.notificationChannel = aws.sdk.kotlin.services.rekognition.model.NotificationChannel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Video] inside the given [block]
         */
        public fun video(block: aws.sdk.kotlin.services.rekognition.model.Video.Builder.() -> kotlin.Unit) {
            this.video = aws.sdk.kotlin.services.rekognition.model.Video.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
