// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartMediaAnalysisJobRequest private constructor(builder: Builder) {
    /**
     * Idempotency token used to prevent the accidental creation of duplicate versions. If you use the same token with multiple `StartMediaAnalysisJobRequest` requests, the same response is returned. Use `ClientRequestToken` to prevent the same request from being processed more than once.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Input data to be analyzed by the job.
     */
    public val input: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisInput? = builder.input
    /**
     * The name of the job. Does not have to be unique.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The identifier of customer managed AWS KMS key (name or ARN). The key is used to encrypt images copied into the service. The key is also used to encrypt results and manifest files written to the output Amazon S3 bucket.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Configuration options for the media analysis job to be created.
     */
    public val operationsConfig: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOperationsConfig? = builder.operationsConfig
    /**
     * The Amazon S3 bucket location to store the results.
     */
    public val outputConfig: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig? = builder.outputConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.StartMediaAnalysisJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartMediaAnalysisJobRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("input=$input,")
        append("jobName=$jobName,")
        append("kmsKeyId=$kmsKeyId,")
        append("operationsConfig=$operationsConfig,")
        append("outputConfig=$outputConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (operationsConfig?.hashCode() ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartMediaAnalysisJobRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (input != other.input) return false
        if (jobName != other.jobName) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (operationsConfig != other.operationsConfig) return false
        if (outputConfig != other.outputConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.StartMediaAnalysisJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Idempotency token used to prevent the accidental creation of duplicate versions. If you use the same token with multiple `StartMediaAnalysisJobRequest` requests, the same response is returned. Use `ClientRequestToken` to prevent the same request from being processed more than once.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Input data to be analyzed by the job.
         */
        public var input: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisInput? = null
        /**
         * The name of the job. Does not have to be unique.
         */
        public var jobName: kotlin.String? = null
        /**
         * The identifier of customer managed AWS KMS key (name or ARN). The key is used to encrypt images copied into the service. The key is also used to encrypt results and manifest files written to the output Amazon S3 bucket.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Configuration options for the media analysis job to be created.
         */
        public var operationsConfig: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOperationsConfig? = null
        /**
         * The Amazon S3 bucket location to store the results.
         */
        public var outputConfig: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.StartMediaAnalysisJobRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.input = x.input
            this.jobName = x.jobName
            this.kmsKeyId = x.kmsKeyId
            this.operationsConfig = x.operationsConfig
            this.outputConfig = x.outputConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.StartMediaAnalysisJobRequest = StartMediaAnalysisJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.MediaAnalysisInput] inside the given [block]
         */
        public fun input(block: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisInput.Builder.() -> kotlin.Unit) {
            this.input = aws.sdk.kotlin.services.rekognition.model.MediaAnalysisInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOperationsConfig] inside the given [block]
         */
        public fun operationsConfig(block: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOperationsConfig.Builder.() -> kotlin.Unit) {
            this.operationsConfig = aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOperationsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.rekognition.model.MediaAnalysisOutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
