// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartLabelDetectionRequest private constructor(builder: Builder) {
    /**
     * Idempotent token used to identify the start request. If you use the same token with multiple `StartLabelDetection` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidently started more than once.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The features to return after video analysis. You can specify that GENERAL_LABELS are returned.
     */
    public val features: List<LabelDetectionFeatureName>? = builder.features
    /**
     * An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use `JobTag` to group related jobs and identify them in the completion notification.
     */
    public val jobTag: kotlin.String? = builder.jobTag
    /**
     * Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected label. Confidence represents how certain Amazon Rekognition is that a label is correctly identified.0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any labels with a confidence level lower than this specified value.
     *
     * If you don't specify `MinConfidence`, the operation returns labels and bounding boxes (if detected) with confidence values greater than or equal to 50 percent.
     */
    public val minConfidence: kotlin.Float? = builder.minConfidence
    /**
     * The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the label detection operation to. The Amazon SNS topic must have a topic name that begins with *AmazonRekognition* if you are using the AmazonRekognitionServiceRole permissions policy.
     */
    public val notificationChannel: aws.sdk.kotlin.services.rekognition.model.NotificationChannel? = builder.notificationChannel
    /**
     * The settings for a StartLabelDetection request.Contains the specified parameters for the label detection request of an asynchronous label analysis operation. Settings can include filters for GENERAL_LABELS.
     */
    public val settings: aws.sdk.kotlin.services.rekognition.model.LabelDetectionSettings? = builder.settings
    /**
     * The video in which you want to detect labels. The video must be stored in an Amazon S3 bucket.
     */
    public val video: aws.sdk.kotlin.services.rekognition.model.Video? = builder.video

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.StartLabelDetectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartLabelDetectionRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("features=$features,")
        append("jobTag=$jobTag,")
        append("minConfidence=$minConfidence,")
        append("notificationChannel=$notificationChannel,")
        append("settings=$settings,")
        append("video=$video")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (features?.hashCode() ?: 0)
        result = 31 * result + (jobTag?.hashCode() ?: 0)
        result = 31 * result + (minConfidence?.hashCode() ?: 0)
        result = 31 * result + (notificationChannel?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (video?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartLabelDetectionRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (features != other.features) return false
        if (jobTag != other.jobTag) return false
        if (minConfidence != other.minConfidence) return false
        if (notificationChannel != other.notificationChannel) return false
        if (settings != other.settings) return false
        if (video != other.video) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.StartLabelDetectionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Idempotent token used to identify the start request. If you use the same token with multiple `StartLabelDetection` requests, the same `JobId` is returned. Use `ClientRequestToken` to prevent the same job from being accidently started more than once.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The features to return after video analysis. You can specify that GENERAL_LABELS are returned.
         */
        public var features: List<LabelDetectionFeatureName>? = null
        /**
         * An identifier you specify that's returned in the completion notification that's published to your Amazon Simple Notification Service topic. For example, you can use `JobTag` to group related jobs and identify them in the completion notification.
         */
        public var jobTag: kotlin.String? = null
        /**
         * Specifies the minimum confidence that Amazon Rekognition Video must have in order to return a detected label. Confidence represents how certain Amazon Rekognition is that a label is correctly identified.0 is the lowest confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't return any labels with a confidence level lower than this specified value.
         *
         * If you don't specify `MinConfidence`, the operation returns labels and bounding boxes (if detected) with confidence values greater than or equal to 50 percent.
         */
        public var minConfidence: kotlin.Float? = null
        /**
         * The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the completion status of the label detection operation to. The Amazon SNS topic must have a topic name that begins with *AmazonRekognition* if you are using the AmazonRekognitionServiceRole permissions policy.
         */
        public var notificationChannel: aws.sdk.kotlin.services.rekognition.model.NotificationChannel? = null
        /**
         * The settings for a StartLabelDetection request.Contains the specified parameters for the label detection request of an asynchronous label analysis operation. Settings can include filters for GENERAL_LABELS.
         */
        public var settings: aws.sdk.kotlin.services.rekognition.model.LabelDetectionSettings? = null
        /**
         * The video in which you want to detect labels. The video must be stored in an Amazon S3 bucket.
         */
        public var video: aws.sdk.kotlin.services.rekognition.model.Video? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.StartLabelDetectionRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.features = x.features
            this.jobTag = x.jobTag
            this.minConfidence = x.minConfidence
            this.notificationChannel = x.notificationChannel
            this.settings = x.settings
            this.video = x.video
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.StartLabelDetectionRequest = StartLabelDetectionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.NotificationChannel] inside the given [block]
         */
        public fun notificationChannel(block: aws.sdk.kotlin.services.rekognition.model.NotificationChannel.Builder.() -> kotlin.Unit) {
            this.notificationChannel = aws.sdk.kotlin.services.rekognition.model.NotificationChannel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.LabelDetectionSettings] inside the given [block]
         */
        public fun settings(block: aws.sdk.kotlin.services.rekognition.model.LabelDetectionSettings.Builder.() -> kotlin.Unit) {
            this.settings = aws.sdk.kotlin.services.rekognition.model.LabelDetectionSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Video] inside the given [block]
         */
        public fun video(block: aws.sdk.kotlin.services.rekognition.model.Video.Builder.() -> kotlin.Unit) {
            this.video = aws.sdk.kotlin.services.rekognition.model.Video.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
