// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SearchUsersByImageRequest private constructor(builder: Builder) {
    /**
     * The ID of an existing collection containing the UserID.
     */
    public val collectionId: kotlin.String? = builder.collectionId
    /**
     * Provides the input image either as bytes or an S3 object.
     *
     * You pass image bytes to an Amazon Rekognition API operation by using the `Bytes` property. For example, you would use the `Bytes` property to pass an image loaded from a local file system. Image bytes passed by using the `Bytes` property must be base64-encoded. Your code may not need to encode image bytes if you are using an AWS SDK to call Amazon Rekognition API operations.
     *
     * For more information, see Analyzing an Image Loaded from a Local File System in the Amazon Rekognition Developer Guide.
     *
     *  You pass images stored in an S3 bucket to an Amazon Rekognition API operation by using the `S3Object` property. Images stored in an S3 bucket do not need to be base64-encoded.
     *
     * The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.
     *
     * If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes using the Bytes property is not supported. You must first upload the image to an Amazon S3 bucket and then call the operation using the S3Object property.
     *
     * For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see How Amazon Rekognition works with IAM in the Amazon Rekognition Developer Guide.
     */
    public val image: aws.sdk.kotlin.services.rekognition.model.Image? = builder.image
    /**
     * Maximum number of UserIDs to return.
     */
    public val maxUsers: kotlin.Int? = builder.maxUsers
    /**
     * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't searched for in the collection. The default value is NONE.
     */
    public val qualityFilter: aws.sdk.kotlin.services.rekognition.model.QualityFilter? = builder.qualityFilter
    /**
     * Specifies the minimum confidence in the UserID match to return. Default value is 80.
     */
    public val userMatchThreshold: kotlin.Float? = builder.userMatchThreshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.SearchUsersByImageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchUsersByImageRequest(")
        append("collectionId=$collectionId,")
        append("image=$image,")
        append("maxUsers=$maxUsers,")
        append("qualityFilter=$qualityFilter,")
        append("userMatchThreshold=$userMatchThreshold")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionId?.hashCode() ?: 0
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (maxUsers ?: 0)
        result = 31 * result + (qualityFilter?.hashCode() ?: 0)
        result = 31 * result + (userMatchThreshold?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchUsersByImageRequest

        if (collectionId != other.collectionId) return false
        if (image != other.image) return false
        if (maxUsers != other.maxUsers) return false
        if (qualityFilter != other.qualityFilter) return false
        if (userMatchThreshold != other.userMatchThreshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.SearchUsersByImageRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of an existing collection containing the UserID.
         */
        public var collectionId: kotlin.String? = null
        /**
         * Provides the input image either as bytes or an S3 object.
         *
         * You pass image bytes to an Amazon Rekognition API operation by using the `Bytes` property. For example, you would use the `Bytes` property to pass an image loaded from a local file system. Image bytes passed by using the `Bytes` property must be base64-encoded. Your code may not need to encode image bytes if you are using an AWS SDK to call Amazon Rekognition API operations.
         *
         * For more information, see Analyzing an Image Loaded from a Local File System in the Amazon Rekognition Developer Guide.
         *
         *  You pass images stored in an S3 bucket to an Amazon Rekognition API operation by using the `S3Object` property. Images stored in an S3 bucket do not need to be base64-encoded.
         *
         * The region for the S3 bucket containing the S3 object must match the region you use for Amazon Rekognition operations.
         *
         * If you use the AWS CLI to call Amazon Rekognition operations, passing image bytes using the Bytes property is not supported. You must first upload the image to an Amazon S3 bucket and then call the operation using the S3Object property.
         *
         * For Amazon Rekognition to process an S3 object, the user must have permission to access the S3 object. For more information, see How Amazon Rekognition works with IAM in the Amazon Rekognition Developer Guide.
         */
        public var image: aws.sdk.kotlin.services.rekognition.model.Image? = null
        /**
         * Maximum number of UserIDs to return.
         */
        public var maxUsers: kotlin.Int? = null
        /**
         * A filter that specifies a quality bar for how much filtering is done to identify faces. Filtered faces aren't searched for in the collection. The default value is NONE.
         */
        public var qualityFilter: aws.sdk.kotlin.services.rekognition.model.QualityFilter? = null
        /**
         * Specifies the minimum confidence in the UserID match to return. Default value is 80.
         */
        public var userMatchThreshold: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.SearchUsersByImageRequest) : this() {
            this.collectionId = x.collectionId
            this.image = x.image
            this.maxUsers = x.maxUsers
            this.qualityFilter = x.qualityFilter
            this.userMatchThreshold = x.userMatchThreshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.SearchUsersByImageRequest = SearchUsersByImageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.Image] inside the given [block]
         */
        public fun image(block: aws.sdk.kotlin.services.rekognition.model.Image.Builder.() -> kotlin.Unit) {
            this.image = aws.sdk.kotlin.services.rekognition.model.Image.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
