// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed inference results of a video analysis operation. These results include the name of the stream processor resource, the session ID of the stream processing session, and labeled timestamps and bounding boxes for detected labels.
 */
public class S3Destination private constructor(builder: Builder) {
    /**
     * The name of the Amazon S3 bucket you want to associate with the streaming video project. You must be the owner of the Amazon S3 bucket.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The prefix value of the location within the bucket that you want the information to be published to. For more information, see [Using prefixes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html).
     */
    public val keyPrefix: kotlin.String? = builder.keyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.S3Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Destination(")
        append("bucket=$bucket,")
        append("keyPrefix=$keyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (keyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Destination

        if (bucket != other.bucket) return false
        if (keyPrefix != other.keyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.S3Destination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Amazon S3 bucket you want to associate with the streaming video project. You must be the owner of the Amazon S3 bucket.
         */
        public var bucket: kotlin.String? = null
        /**
         * The prefix value of the location within the bucket that you want the information to be published to. For more information, see [Using prefixes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html).
         */
        public var keyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.S3Destination) : this() {
            this.bucket = x.bucket
            this.keyPrefix = x.keyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.S3Destination = S3Destination(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
