// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Summary information for required items of personal protective equipment (PPE) detected on persons by a call to DetectProtectiveEquipment. You specify the required type of PPE in the `SummarizationAttributes` (ProtectiveEquipmentSummarizationAttributes) input parameter. The summary includes which persons were detected wearing the required personal protective equipment (`PersonsWithRequiredEquipment`), which persons were detected as not wearing the required PPE (`PersonsWithoutRequiredEquipment`), and the persons in which a determination could not be made (`PersonsIndeterminate`).
 *
 * To get a total for each category, use the size of the field array. For example, to find out how many people were detected as wearing the specified PPE, use the size of the `PersonsWithRequiredEquipment` array. If you want to find out more about a person, such as the location (BoundingBox) of the person on the image, use the person ID in each array element. Each person ID matches the ID field of a ProtectiveEquipmentPerson object returned in the `Persons` array by `DetectProtectiveEquipment`.
 */
public class ProtectiveEquipmentSummary private constructor(builder: Builder) {
    /**
     * An array of IDs for persons where it was not possible to determine if they are wearing personal protective equipment.
     */
    public val personsIndeterminate: List<Int>? = builder.personsIndeterminate
    /**
     * An array of IDs for persons who are wearing detected personal protective equipment.
     */
    public val personsWithRequiredEquipment: List<Int>? = builder.personsWithRequiredEquipment
    /**
     * An array of IDs for persons who are not wearing all of the types of PPE specified in the `RequiredEquipmentTypes` field of the detected personal protective equipment.
     */
    public val personsWithoutRequiredEquipment: List<Int>? = builder.personsWithoutRequiredEquipment

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.ProtectiveEquipmentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProtectiveEquipmentSummary(")
        append("personsIndeterminate=$personsIndeterminate,")
        append("personsWithRequiredEquipment=$personsWithRequiredEquipment,")
        append("personsWithoutRequiredEquipment=$personsWithoutRequiredEquipment")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = personsIndeterminate?.hashCode() ?: 0
        result = 31 * result + (personsWithRequiredEquipment?.hashCode() ?: 0)
        result = 31 * result + (personsWithoutRequiredEquipment?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProtectiveEquipmentSummary

        if (personsIndeterminate != other.personsIndeterminate) return false
        if (personsWithRequiredEquipment != other.personsWithRequiredEquipment) return false
        if (personsWithoutRequiredEquipment != other.personsWithoutRequiredEquipment) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.ProtectiveEquipmentSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of IDs for persons where it was not possible to determine if they are wearing personal protective equipment.
         */
        public var personsIndeterminate: List<Int>? = null
        /**
         * An array of IDs for persons who are wearing detected personal protective equipment.
         */
        public var personsWithRequiredEquipment: List<Int>? = null
        /**
         * An array of IDs for persons who are not wearing all of the types of PPE specified in the `RequiredEquipmentTypes` field of the detected personal protective equipment.
         */
        public var personsWithoutRequiredEquipment: List<Int>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.ProtectiveEquipmentSummary) : this() {
            this.personsIndeterminate = x.personsIndeterminate
            this.personsWithRequiredEquipment = x.personsWithRequiredEquipment
            this.personsWithoutRequiredEquipment = x.personsWithoutRequiredEquipment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.ProtectiveEquipmentSummary = ProtectiveEquipmentSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
