// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies summary attributes to return from a call to DetectProtectiveEquipment. You can specify which types of PPE to summarize. You can also specify a minimum confidence value for detections. Summary information is returned in the `Summary` (ProtectiveEquipmentSummary) field of the response from `DetectProtectiveEquipment`. The summary includes which persons in an image were detected wearing the requested types of person protective equipment (PPE), which persons were detected as not wearing PPE, and the persons in which a determination could not be made. For more information, see ProtectiveEquipmentSummary.
 */
public class ProtectiveEquipmentSummarizationAttributes private constructor(builder: Builder) {
    /**
     * The minimum confidence level for which you want summary information. The confidence level applies to person detection, body part detection, equipment detection, and body part coverage. Amazon Rekognition doesn't return summary information with a confidence than this specified value. There isn't a default value.
     *
     * Specify a `MinConfidence` value that is between 50-100% as `DetectProtectiveEquipment` returns predictions only where the detection confidence is between 50% - 100%. If you specify a value that is less than 50%, the results are the same specifying a value of 50%.
     */
    public val minConfidence: kotlin.Float = requireNotNull(builder.minConfidence) { "A non-null value must be provided for minConfidence" }
    /**
     * An array of personal protective equipment types for which you want summary information. If a person is detected wearing a required requipment type, the person's ID is added to the `PersonsWithRequiredEquipment` array field returned in ProtectiveEquipmentSummary by `DetectProtectiveEquipment`.
     */
    public val requiredEquipmentTypes: List<ProtectiveEquipmentType> = requireNotNull(builder.requiredEquipmentTypes) { "A non-null value must be provided for requiredEquipmentTypes" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.ProtectiveEquipmentSummarizationAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProtectiveEquipmentSummarizationAttributes(")
        append("minConfidence=$minConfidence,")
        append("requiredEquipmentTypes=$requiredEquipmentTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = minConfidence.hashCode()
        result = 31 * result + (requiredEquipmentTypes.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProtectiveEquipmentSummarizationAttributes

        if (minConfidence != other.minConfidence) return false
        if (requiredEquipmentTypes != other.requiredEquipmentTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.ProtectiveEquipmentSummarizationAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The minimum confidence level for which you want summary information. The confidence level applies to person detection, body part detection, equipment detection, and body part coverage. Amazon Rekognition doesn't return summary information with a confidence than this specified value. There isn't a default value.
         *
         * Specify a `MinConfidence` value that is between 50-100% as `DetectProtectiveEquipment` returns predictions only where the detection confidence is between 50% - 100%. If you specify a value that is less than 50%, the results are the same specifying a value of 50%.
         */
        public var minConfidence: kotlin.Float? = null
        /**
         * An array of personal protective equipment types for which you want summary information. If a person is detected wearing a required requipment type, the person's ID is added to the `PersonsWithRequiredEquipment` array field returned in ProtectiveEquipmentSummary by `DetectProtectiveEquipment`.
         */
        public var requiredEquipmentTypes: List<ProtectiveEquipmentType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.ProtectiveEquipmentSummarizationAttributes) : this() {
            this.minConfidence = x.minConfidence
            this.requiredEquipmentTypes = x.requiredEquipmentTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.ProtectiveEquipmentSummarizationAttributes = ProtectiveEquipmentSummarizationAttributes(this)

        internal fun correctErrors(): Builder {
            if (minConfidence == null) minConfidence = 0f
            if (requiredEquipmentTypes == null) requiredEquipmentTypes = emptyList()
            return this
        }
    }
}
