// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A description of a version of a Amazon Rekognition project version.
 */
public class ProjectVersionDescription private constructor(builder: Builder) {
    /**
     * The base detection model version used to create the project version.
     */
    public val baseModelVersion: kotlin.String? = builder.baseModelVersion
    /**
     * The duration, in seconds, that you were billed for a successful training of the model version. This value is only returned if the model version has been successfully trained.
     */
    public val billableTrainingTimeInSeconds: kotlin.Long? = builder.billableTrainingTimeInSeconds
    /**
     * The Unix datetime for the date and time that training started.
     */
    public val creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTimestamp
    /**
     * The training results. `EvaluationResult` is only returned if training is successful.
     */
    public val evaluationResult: aws.sdk.kotlin.services.rekognition.model.EvaluationResult? = builder.evaluationResult
    /**
     * The feature that was customized.
     */
    public val feature: aws.sdk.kotlin.services.rekognition.model.CustomizationFeature? = builder.feature
    /**
     * Feature specific configuration that was applied during training.
     */
    public val featureConfig: aws.sdk.kotlin.services.rekognition.model.CustomizationFeatureConfig? = builder.featureConfig
    /**
     * The identifer for the AWS Key Management Service key (AWS KMS key) that was used to encrypt the model during training.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The location of the summary manifest. The summary manifest provides aggregate data validation results for the training and test datasets.
     */
    public val manifestSummary: aws.sdk.kotlin.services.rekognition.model.GroundTruthManifest? = builder.manifestSummary
    /**
     * The maximum number of inference units Amazon Rekognition uses to auto-scale the model. Applies only to Custom Labels projects. For more information, see StartProjectVersion.
     */
    public val maxInferenceUnits: kotlin.Int? = builder.maxInferenceUnits
    /**
     * The minimum number of inference units used by the model. Applies only to Custom Labels projects. For more information, see StartProjectVersion.
     */
    public val minInferenceUnits: kotlin.Int? = builder.minInferenceUnits
    /**
     * The location where training results are saved.
     */
    public val outputConfig: aws.sdk.kotlin.services.rekognition.model.OutputConfig? = builder.outputConfig
    /**
     * The Amazon Resource Name (ARN) of the project version.
     */
    public val projectVersionArn: kotlin.String? = builder.projectVersionArn
    /**
     * If the model version was copied from a different project, `SourceProjectVersionArn` contains the ARN of the source model version.
     */
    public val sourceProjectVersionArn: kotlin.String? = builder.sourceProjectVersionArn
    /**
     * The current status of the model version.
     */
    public val status: aws.sdk.kotlin.services.rekognition.model.ProjectVersionStatus? = builder.status
    /**
     * A descriptive message for an error or warning that occurred.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * Contains information about the testing results.
     */
    public val testingDataResult: aws.sdk.kotlin.services.rekognition.model.TestingDataResult? = builder.testingDataResult
    /**
     * Contains information about the training results.
     */
    public val trainingDataResult: aws.sdk.kotlin.services.rekognition.model.TrainingDataResult? = builder.trainingDataResult
    /**
     * The Unix date and time that training of the model ended.
     */
    public val trainingEndTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingEndTimestamp
    /**
     * A user-provided description of the project version.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.ProjectVersionDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProjectVersionDescription(")
        append("baseModelVersion=$baseModelVersion,")
        append("billableTrainingTimeInSeconds=$billableTrainingTimeInSeconds,")
        append("creationTimestamp=$creationTimestamp,")
        append("evaluationResult=$evaluationResult,")
        append("feature=$feature,")
        append("featureConfig=$featureConfig,")
        append("kmsKeyId=$kmsKeyId,")
        append("manifestSummary=$manifestSummary,")
        append("maxInferenceUnits=$maxInferenceUnits,")
        append("minInferenceUnits=$minInferenceUnits,")
        append("outputConfig=$outputConfig,")
        append("projectVersionArn=$projectVersionArn,")
        append("sourceProjectVersionArn=$sourceProjectVersionArn,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("testingDataResult=$testingDataResult,")
        append("trainingDataResult=$trainingDataResult,")
        append("trainingEndTimestamp=$trainingEndTimestamp,")
        append("versionDescription=$versionDescription")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseModelVersion?.hashCode() ?: 0
        result = 31 * result + (billableTrainingTimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (creationTimestamp?.hashCode() ?: 0)
        result = 31 * result + (evaluationResult?.hashCode() ?: 0)
        result = 31 * result + (feature?.hashCode() ?: 0)
        result = 31 * result + (featureConfig?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (manifestSummary?.hashCode() ?: 0)
        result = 31 * result + (maxInferenceUnits ?: 0)
        result = 31 * result + (minInferenceUnits ?: 0)
        result = 31 * result + (outputConfig?.hashCode() ?: 0)
        result = 31 * result + (projectVersionArn?.hashCode() ?: 0)
        result = 31 * result + (sourceProjectVersionArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (testingDataResult?.hashCode() ?: 0)
        result = 31 * result + (trainingDataResult?.hashCode() ?: 0)
        result = 31 * result + (trainingEndTimestamp?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProjectVersionDescription

        if (baseModelVersion != other.baseModelVersion) return false
        if (billableTrainingTimeInSeconds != other.billableTrainingTimeInSeconds) return false
        if (creationTimestamp != other.creationTimestamp) return false
        if (evaluationResult != other.evaluationResult) return false
        if (feature != other.feature) return false
        if (featureConfig != other.featureConfig) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (manifestSummary != other.manifestSummary) return false
        if (maxInferenceUnits != other.maxInferenceUnits) return false
        if (minInferenceUnits != other.minInferenceUnits) return false
        if (outputConfig != other.outputConfig) return false
        if (projectVersionArn != other.projectVersionArn) return false
        if (sourceProjectVersionArn != other.sourceProjectVersionArn) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (testingDataResult != other.testingDataResult) return false
        if (trainingDataResult != other.trainingDataResult) return false
        if (trainingEndTimestamp != other.trainingEndTimestamp) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.ProjectVersionDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The base detection model version used to create the project version.
         */
        public var baseModelVersion: kotlin.String? = null
        /**
         * The duration, in seconds, that you were billed for a successful training of the model version. This value is only returned if the model version has been successfully trained.
         */
        public var billableTrainingTimeInSeconds: kotlin.Long? = null
        /**
         * The Unix datetime for the date and time that training started.
         */
        public var creationTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The training results. `EvaluationResult` is only returned if training is successful.
         */
        public var evaluationResult: aws.sdk.kotlin.services.rekognition.model.EvaluationResult? = null
        /**
         * The feature that was customized.
         */
        public var feature: aws.sdk.kotlin.services.rekognition.model.CustomizationFeature? = null
        /**
         * Feature specific configuration that was applied during training.
         */
        public var featureConfig: aws.sdk.kotlin.services.rekognition.model.CustomizationFeatureConfig? = null
        /**
         * The identifer for the AWS Key Management Service key (AWS KMS key) that was used to encrypt the model during training.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The location of the summary manifest. The summary manifest provides aggregate data validation results for the training and test datasets.
         */
        public var manifestSummary: aws.sdk.kotlin.services.rekognition.model.GroundTruthManifest? = null
        /**
         * The maximum number of inference units Amazon Rekognition uses to auto-scale the model. Applies only to Custom Labels projects. For more information, see StartProjectVersion.
         */
        public var maxInferenceUnits: kotlin.Int? = null
        /**
         * The minimum number of inference units used by the model. Applies only to Custom Labels projects. For more information, see StartProjectVersion.
         */
        public var minInferenceUnits: kotlin.Int? = null
        /**
         * The location where training results are saved.
         */
        public var outputConfig: aws.sdk.kotlin.services.rekognition.model.OutputConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the project version.
         */
        public var projectVersionArn: kotlin.String? = null
        /**
         * If the model version was copied from a different project, `SourceProjectVersionArn` contains the ARN of the source model version.
         */
        public var sourceProjectVersionArn: kotlin.String? = null
        /**
         * The current status of the model version.
         */
        public var status: aws.sdk.kotlin.services.rekognition.model.ProjectVersionStatus? = null
        /**
         * A descriptive message for an error or warning that occurred.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * Contains information about the testing results.
         */
        public var testingDataResult: aws.sdk.kotlin.services.rekognition.model.TestingDataResult? = null
        /**
         * Contains information about the training results.
         */
        public var trainingDataResult: aws.sdk.kotlin.services.rekognition.model.TrainingDataResult? = null
        /**
         * The Unix date and time that training of the model ended.
         */
        public var trainingEndTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A user-provided description of the project version.
         */
        public var versionDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.ProjectVersionDescription) : this() {
            this.baseModelVersion = x.baseModelVersion
            this.billableTrainingTimeInSeconds = x.billableTrainingTimeInSeconds
            this.creationTimestamp = x.creationTimestamp
            this.evaluationResult = x.evaluationResult
            this.feature = x.feature
            this.featureConfig = x.featureConfig
            this.kmsKeyId = x.kmsKeyId
            this.manifestSummary = x.manifestSummary
            this.maxInferenceUnits = x.maxInferenceUnits
            this.minInferenceUnits = x.minInferenceUnits
            this.outputConfig = x.outputConfig
            this.projectVersionArn = x.projectVersionArn
            this.sourceProjectVersionArn = x.sourceProjectVersionArn
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.testingDataResult = x.testingDataResult
            this.trainingDataResult = x.trainingDataResult
            this.trainingEndTimestamp = x.trainingEndTimestamp
            this.versionDescription = x.versionDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.ProjectVersionDescription = ProjectVersionDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.EvaluationResult] inside the given [block]
         */
        public fun evaluationResult(block: aws.sdk.kotlin.services.rekognition.model.EvaluationResult.Builder.() -> kotlin.Unit) {
            this.evaluationResult = aws.sdk.kotlin.services.rekognition.model.EvaluationResult.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.CustomizationFeatureConfig] inside the given [block]
         */
        public fun featureConfig(block: aws.sdk.kotlin.services.rekognition.model.CustomizationFeatureConfig.Builder.() -> kotlin.Unit) {
            this.featureConfig = aws.sdk.kotlin.services.rekognition.model.CustomizationFeatureConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.GroundTruthManifest] inside the given [block]
         */
        public fun manifestSummary(block: aws.sdk.kotlin.services.rekognition.model.GroundTruthManifest.Builder.() -> kotlin.Unit) {
            this.manifestSummary = aws.sdk.kotlin.services.rekognition.model.GroundTruthManifest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.OutputConfig] inside the given [block]
         */
        public fun outputConfig(block: aws.sdk.kotlin.services.rekognition.model.OutputConfig.Builder.() -> kotlin.Unit) {
            this.outputConfig = aws.sdk.kotlin.services.rekognition.model.OutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.TestingDataResult] inside the given [block]
         */
        public fun testingDataResult(block: aws.sdk.kotlin.services.rekognition.model.TestingDataResult.Builder.() -> kotlin.Unit) {
            this.testingDataResult = aws.sdk.kotlin.services.rekognition.model.TestingDataResult.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.TrainingDataResult] inside the given [block]
         */
        public fun trainingDataResult(block: aws.sdk.kotlin.services.rekognition.model.TrainingDataResult.Builder.() -> kotlin.Unit) {
            this.trainingDataResult = aws.sdk.kotlin.services.rekognition.model.TrainingDataResult.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
