// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rekognition.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a person whose face matches a face(s) in an Amazon Rekognition collection. Includes information about the faces in the Amazon Rekognition collection (FaceMatch), information about the person (PersonDetail), and the time stamp for when the person was detected in a video. An array of `PersonMatch` objects is returned by GetFaceSearch.
 */
public class PersonMatch private constructor(builder: Builder) {
    /**
     * Information about the faces in the input collection that match the face of a person in the video.
     */
    public val faceMatches: List<FaceMatch>? = builder.faceMatches
    /**
     * Information about the matched person.
     */
    public val person: aws.sdk.kotlin.services.rekognition.model.PersonDetail? = builder.person
    /**
     * The time, in milliseconds from the beginning of the video, that the person was matched in the video.
     */
    public val timestamp: kotlin.Long = builder.timestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rekognition.model.PersonMatch = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PersonMatch(")
        append("faceMatches=$faceMatches,")
        append("person=$person,")
        append("timestamp=$timestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = faceMatches?.hashCode() ?: 0
        result = 31 * result + (person?.hashCode() ?: 0)
        result = 31 * result + (timestamp.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PersonMatch

        if (faceMatches != other.faceMatches) return false
        if (person != other.person) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rekognition.model.PersonMatch = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the faces in the input collection that match the face of a person in the video.
         */
        public var faceMatches: List<FaceMatch>? = null
        /**
         * Information about the matched person.
         */
        public var person: aws.sdk.kotlin.services.rekognition.model.PersonDetail? = null
        /**
         * The time, in milliseconds from the beginning of the video, that the person was matched in the video.
         */
        public var timestamp: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rekognition.model.PersonMatch) : this() {
            this.faceMatches = x.faceMatches
            this.person = x.person
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rekognition.model.PersonMatch = PersonMatch(this)

        /**
         * construct an [aws.sdk.kotlin.services.rekognition.model.PersonDetail] inside the given [block]
         */
        public fun person(block: aws.sdk.kotlin.services.rekognition.model.PersonDetail.Builder.() -> kotlin.Unit) {
            this.person = aws.sdk.kotlin.services.rekognition.model.PersonDetail.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
